/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosUtil {
    public static ItemStack findSlot(LivingEntity entity, String identifier) {
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!optional.isPresent()) {
            return ItemStack.f_41583_;
        }
        ICuriosItemHandler inventory = (ICuriosItemHandler)optional.resolve().orElseThrow();
        Optional result = inventory.findCurio(identifier, 0);
        if (result.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((SlotResult)result.get()).stack();
    }

    public static List<ItemStack> findSlots(LivingEntity entity, String ... identifiers) {
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!optional.isPresent()) {
            return List.of();
        }
        ICuriosItemHandler inventory = (ICuriosItemHandler)optional.resolve().orElseThrow();
        return inventory.findCurios(identifiers).stream().map(SlotResult::stack).collect(Collectors.toList());
    }

    public static void setItemInSlot(LivingEntity entity, String identifier, ItemStack stack) {
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (!optional.isPresent()) {
            return;
        }
        ICuriosItemHandler inventory = (ICuriosItemHandler)optional.resolve().orElseThrow();
        inventory.setEquippedCurio(identifier, 0, stack);
    }
}

