/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.RCT1;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.util.HelperMethods;

public class EntityUtil {
    private static final UUID CE_FLOW_ARMOR_UUID = UUID.fromString("c7b8f3f0-9c4f-4e76-b69f-dc2f3d94e7b8");
    private static final UUID CE_FLOW_ARMOR_TOUGHNESS_UUID = UUID.fromString("f3a3c0e2-bc9a-45a2-9219-0f1f6de65c17");
    private static Map<UUID, Float> lastArmorBonus = new HashMap<UUID, Float>();
    private static Map<UUID, Float> lastToughnessBonus = new HashMap<UUID, Float>();

    @Nullable
    public static LivingEntity getOwner(TamableAnimal tamable) {
        TamableAnimal parent;
        TamableAnimal owner = tamable;
        while (owner instanceof TamableAnimal && (parent = owner).m_21824_()) {
            owner = parent.m_269323_();
            if (owner != null) continue;
            return null;
        }
        return owner;
    }

    public static <T extends Entity> List<T> getTargetableEntities(Class<T> clazz, EntityGetter getter, @Nullable LivingEntity owner, AABB bounds) {
        return getter.m_6443_(clazz, bounds, EntitySelector.f_20402_.and(EntitySelector.f_20406_).and(entity -> {
            TamableAnimal tamable;
            return owner == null || entity != owner && (!(entity instanceof TamableAnimal) || EntityUtil.getOwner(tamable = (TamableAnimal)entity) != owner);
        }));
    }

    public static <T extends Entity> List<T> getTouchableEntities(Class<T> clazz, EntityGetter getter, @Nullable LivingEntity owner, AABB bounds) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : EntityUtil.getTargetableEntities(clazz, getter, owner, bounds)) {
            ISorcererData cap = owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
            if (cap != null && cap.hasToggled((Ability)JJKAbilities.INFINITY.get())) continue;
            entities.add(entity);
        }
        return entities;
    }

    public static void makePoofParticles(Entity entity) {
        for (int i = 0; i < 20; ++i) {
            double d0 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d1 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d2 = HelperMethods.RANDOM.m_188583_() * 0.02;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0, d0, d1, d2, 1.0);
        }
    }

    public static void applyArmorBoost(LivingEntity owner) {
        if (!(owner instanceof Player)) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        EntityUtil.removeModifier(owner, Attributes.f_22284_, CE_FLOW_ARMOR_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22285_, CE_FLOW_ARMOR_TOUGHNESS_UUID);
        float currentArmor = (float)owner.m_21133_(Attributes.f_22284_);
        float currentToughness = (float)owner.m_21133_(Attributes.f_22285_);
        float ceFlowArmorBonus = ((Double)ConfigHolder.SERVER.playerCEArmorMin.get()).floatValue() + ((Double)ConfigHolder.SERVER.playerCEArmor.get()).floatValue() * (cap.getExperience() / SorcererGrade.SPECIAL_GRADE.getRequiredExperience());
        float ceFlowToughnessBonus = ((Double)ConfigHolder.SERVER.playerCEArmorMin.get()).floatValue() / 2.0f + ((Double)ConfigHolder.SERVER.playerCEArmor.get()).floatValue() * 0.575f * (cap.getExperience() / SorcererGrade.SPECIAL_GRADE.getRequiredExperience());
        float maxArmor = ((Double)ConfigHolder.SERVER.playerCEArmorMax.get()).floatValue();
        float maxToughness = maxArmor * 0.6f;
        if (currentArmor + ceFlowArmorBonus > maxArmor) {
            ceFlowArmorBonus = Math.max(0.0f, maxArmor - currentArmor);
        }
        if (currentToughness + ceFlowToughnessBonus > maxToughness) {
            ceFlowToughnessBonus = Math.max(0.0f, maxToughness - currentToughness);
        }
        EntityUtil.applyModifier(owner, Attributes.f_22284_, CE_FLOW_ARMOR_UUID, "CE Flow Armor Bonus", ceFlowArmorBonus, AttributeModifier.Operation.ADDITION);
        EntityUtil.applyModifier(owner, Attributes.f_22285_, CE_FLOW_ARMOR_TOUGHNESS_UUID, "CE Flow Armor Toughness Bonus", ceFlowToughnessBonus, AttributeModifier.Operation.ADDITION);
    }

    public static void removeArmorBoost(LivingEntity owner) {
        EntityUtil.removeModifier(owner, Attributes.f_22284_, CE_FLOW_ARMOR_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22285_, CE_FLOW_ARMOR_TOUGHNESS_UUID);
    }

    public static void rotation(Entity entity, Vec3 look) {
        double d0 = look.m_165924_();
        entity.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
        entity.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
    }

    public static void offset(Entity entity, Vec3 look, Vec3 pos) {
        EntityUtil.rotation(entity, look);
        entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static void convertTo(LivingEntity src, LivingEntity dst, boolean transferInventory, boolean kill) {
        if (!src.m_213877_()) {
            dst.m_20359_((Entity)src);
            if (src.m_8077_()) {
                dst.m_6593_(src.m_7770_());
                dst.m_20340_(src.m_20151_());
            }
            dst.m_20331_(src.m_20147_());
            if (transferInventory) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack stack = src.m_6844_(slot);
                    if (stack.m_41619_()) continue;
                    dst.m_8061_(slot, stack.m_41777_());
                }
            }
            src.m_9236_().m_7967_((Entity)dst);
            if (src.m_20159_()) {
                Entity vehicle = src.m_20202_();
                src.m_8127_();
                if (vehicle != null) {
                    vehicle.m_7998_(vehicle, true);
                }
            }
            if (kill) {
                if (src instanceof Player && !src.m_21224_()) {
                    src.m_6074_();
                } else {
                    src.m_146870_();
                }
            }
        }
    }

    @Nullable
    public static RCT1 getRCTTier(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.isUnlocked((Ability)JJKAbilities.RCT3.get())) {
            return (RCT1)JJKAbilities.RCT3.get();
        }
        if (cap.isUnlocked((Ability)JJKAbilities.RCT2.get())) {
            return (RCT1)JJKAbilities.RCT2.get();
        }
        if (cap.isUnlocked((Ability)JJKAbilities.RCT1.get())) {
            return (RCT1)JJKAbilities.RCT1.get();
        }
        return null;
    }

    public static boolean applyModifier(LivingEntity owner, Attribute attribute, UUID identifier, String name, double amount, AttributeModifier.Operation operation) {
        AttributeInstance instance = owner.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(identifier, name, amount, operation);
        if (instance != null) {
            AttributeModifier existing = instance.m_22111_(identifier);
            if (existing != null) {
                if (existing.m_22218_() != amount) {
                    instance.m_22120_(identifier);
                    instance.m_22118_(modifier);
                    return true;
                }
            } else {
                instance.m_22118_(modifier);
                return true;
            }
        }
        return false;
    }

    public static void removeModifier(LivingEntity owner, Attribute attribute, UUID identifier) {
        AttributeInstance instance = owner.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(identifier);
        }
    }
}

