/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.angel;

import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.entity.effect.MaximumOutputJacobsLadderEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class MaximumOutputJacobsLadder
extends Ability {
    public static final double RANGE = 100.0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return true;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        EntityHitResult hit;
        HitResult hitResult = RotationUtil.getLookAtHit((Entity)owner, 100.0);
        if (hitResult instanceof EntityHitResult && (hitResult = (hit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitResult;
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(LivingEntity owner) {
        Vec3 pos;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            Vec3 topCenter;
            BlockHitResult hit = this.getBlockHit(owner, 100.0);
            if (hit == null) return;
            pos = topCenter = Vec3.m_82512_((Vec3i)hit.m_82425_()).m_82520_(0.0, 0.5, 0.0);
        } else {
            pos = target.m_20182_();
        }
        float output = ChantHandler.getOutput(owner, this);
        MaximumOutputJacobsLadderEntity strike = new MaximumOutputJacobsLadderEntity(owner, this.getPower(owner), pos, output);
        owner.m_9236_().m_7967_((Entity)strike);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target = this.getTarget(owner);
        BlockHitResult hit = this.getBlockHit(owner, 100.0);
        if (target == null && hit == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 450.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

