/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;

public class SummonAll
extends Ability {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return target != null && !target.m_21224_() && owner.m_142582_((Entity)target) && (cap.getType() == JujutsuType.CURSE || cap.isUnlocked((Ability)JJKAbilities.RCT1.get()) ? owner.m_21223_() / owner.m_21233_() < 0.9f : owner.m_21223_() / owner.m_21233_() < 0.4f);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        List<AbsorbedCurse> curses = cap.getCurses();
        for (AbsorbedCurse curse : curses) {
            JJKAbilities.summonCurse(owner, curse, false);
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getCurses().isEmpty()) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        List<AbsorbedCurse> curses = cap.getCurses();
        float cost = 0.0f;
        for (AbsorbedCurse curse : curses) {
            cost += JJKAbilities.getCurseCost(curse);
        }
        return cost;
    }

    @Override
    public float getRealCost(LivingEntity owner) {
        return this.getCost(owner);
    }
}

