/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.dismantle_and_cleave;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.projectile.DismantleProjectile;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Spiderweb
extends Ability {
    private static final int RANGE = 9;
    private static final int DELAY = 20;
    private static final float EXPLOSIVE_POWER = 3.0f;
    private static final float MAX_EXPLOSIVE_POWER = 30.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && !target.m_21224_() && HelperMethods.RANDOM.m_188503_(10) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private BlockHitResult getBlockHit(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(9.0)));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)result;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            Vec3 offset = entity.m_20182_().m_82492_(0.0, 5.0, 0.0);
            return owner.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        owner.m_21011_(InteractionHand.MAIN_HAND, true);
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit != null) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float radius = Math.min(30.0f, 3.0f * this.getPower(owner));
            float real = radius % 2.0f == 0.0f ? radius + 1.0f : radius;
            Vec3 center = hit.m_82425_().m_252807_().m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_((double)(real * 0.01f)));
            AABB bounds = AABB.m_165882_((Vec3)center, (double)real, (double)real, (double)real);
            for (int i = 0; i < HelperMethods.RANDOM.m_216339_(5, 10); ++i) {
                cap.delayTickEvent(() -> {
                    owner.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)JJKSounds.SLASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    BlockPos.m_121921_((AABB)bounds).forEach(pos -> {
                        if (HelperMethods.RANDOM.m_188503_(Math.round(radius) * 2) == 0) {
                            Vec3 current = pos.m_252807_();
                            owner.m_9236_().m_7967_((Entity)new DismantleProjectile(owner, this.getPower(owner) * 1.35f, (HelperMethods.RANDOM.m_188501_() - 0.5f) * 360.0f, current, HelperMethods.RANDOM.m_216339_(3, 13), true, true));
                        }
                    });
                }, i * 2);
            }
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 200.0f;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

