/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.ClientWrapper;
import radon.jujutsu_kaisen.entity.effect.BodyRepelEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class BodyRepel
extends Ability
implements Ability.ICharged {
    private static final int MIN_SOULS = 2;
    private static final int MAX_SOULS = 5;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        if (!owner.m_142582_((Entity)target)) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.isChanneling(this)) {
            return HelperMethods.RANDOM.m_188503_(20) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(40) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    private int getSoulCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return 0;
        }
        return Math.max(2, Math.min(5, Math.min(cap.getTransfiguredSouls(), 1 + this.getCharge(owner) / 2)));
    }

    @Override
    public void run(LivingEntity owner) {
        if (!(owner instanceof Player) || !owner.m_9236_().f_46443_) {
            return;
        }
        ClientWrapper.setOverlayMessage((Component)Component.m_237110_((String)String.format("chat.%s.souls", "jujutsu_kaisen"), (Object[])new Object[]{this.getSoulCost(owner)}), false);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getTransfiguredSouls() < 2) {
            return false;
        }
        return super.isValid(owner);
    }

    @Override
    public boolean onRelease(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        int souls = this.getSoulCost(owner);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return false;
        }
        cap.useTransfiguredSouls(souls);
        owner.m_9236_().m_7967_((Entity)new BodyRepelEntity(owner, souls));
        return true;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 50.0f;
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

