/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class IdleTransfiguration
extends Ability
implements Ability.IToggled,
Ability.IAttack {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return false;
    }

    public static boolean checkSukuna(LivingEntity owner, LivingEntity target) {
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (!targetCap.hasTrait(Trait.VESSEL) || targetCap.getFingers() == 0) {
            return false;
        }
        float experience = (float)targetCap.getFingers() * (SorcererGrade.SPECIAL_GRADE.getRequiredExperience() * 4.0f / 20.0f);
        if (experience <= ownerCap.getExperience()) {
            return false;
        }
        ((Ability.IDomainAttack)JJKAbilities.CLEAVE.get()).performEntity(target, owner, null);
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    public static float calculateStrength(LivingEntity entity) {
        float strength = Math.min(1.0f, entity.m_21223_());
        if (entity instanceof Player) {
            Player player = (Player)entity;
        } else if (strength <= 30.0f) {
            strength = 1.0f;
        }
        if (entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            if (entity.m_9236_().f_46443_) {
                ClientVisualHandler.ClientData data = ClientVisualHandler.get((Entity)entity);
                if (data != null) {
                    strength += data.experience * 0.1f;
                }
            } else {
                ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                strength += cap.getExperience() * 0.1f;
            }
        }
        return strength;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasToggled((Ability)JJKAbilities.SOUL_DECIMATION.get())) {
            cap.toggle((Ability)JJKAbilities.SOUL_DECIMATION.get());
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 60.0f;
    }

    @Override
    public int getCooldown() {
        return 80;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    public static void absorb(LivingEntity owner, LivingEntity target) {
        ItemStack stack = new ItemStack((ItemLike)JJKItems.TRANSFIGURED_SOUL.get());
        if (owner instanceof Player) {
            Player player = (Player)owner;
            player.m_36356_(stack);
        } else {
            owner.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
        EntityUtil.makePoofParticles((Entity)target);
        if (!(target instanceof Player)) {
            target.m_146870_();
        } else {
            target.m_6074_();
        }
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (owner.m_9236_().f_46443_) {
            return false;
        }
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        MobEffectInstance existing = target.m_21124_((MobEffect)JJKEffects.TRANSFIGURED_SOUL.get());
        int amplifier = 0;
        if (existing != null) {
            amplifier = existing.m_19564_() + 1;
        }
        MobEffectInstance instance = new MobEffectInstance((MobEffect)JJKEffects.TRANSFIGURED_SOUL.get(), 240, amplifier, false, true, true);
        target.m_7292_(instance);
        if (!owner.m_9236_().f_46443_) {
            PacketDistributor.TRACKING_ENTITY.with(() -> target).send((Packet)new ClientboundUpdateMobEffectPacket(target.m_19879_(), instance));
        }
        float attackerStrength = IdleTransfiguration.calculateStrength(owner);
        float victimStrength = IdleTransfiguration.calculateStrength(target);
        int required = Math.round(victimStrength / (float)Math.round(attackerStrength * 2.0f / 11.0f) * 2.0f);
        if (victimStrength <= 1.0f) {
            required = 0;
        }
        if (amplifier >= required && (target instanceof Mob && !(target instanceof Monster) || target instanceof Player)) {
            IdleTransfiguration.absorb(owner, target);
            return true;
        }
        if (!owner.m_9236_().f_46443_) {
            PacketDistributor.TRACKING_ENTITY.with(() -> target).send((Packet)new ClientboundUpdateMobEffectPacket(target.m_19879_(), instance));
        }
        return true;
    }
}

