/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;

public class DomainAmplification
extends Ability
implements Ability.IToggled {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_() || (double)owner.m_20270_((Entity)target) > 20.0 || JJKAbilities.hasToggled((LivingEntity)owner, (Ability)JJKAbilities.WHEEL.get())) {
            return false;
        }
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        boolean hasDomainUp = false;
        boolean opponentDomainUp = false;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner && domain.hasSureHitEffect()) {
                hasDomainUp = true;
                continue;
            }
            if (domain.getOwner() != target) continue;
            opponentDomainUp = true;
        }
        ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return (!hasDomainUp || opponentDomainUp) && cap.hasToggled((Ability)JJKAbilities.INFINITY.get());
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public boolean isCursedEnergyColor() {
        return true;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.25f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return technique == null || technique.getDomain() == null ? (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get() : technique.getDomain();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(4.0f, 1.0f);
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.domainAmplificationCost.get();
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class DomainAmplificationForgeEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            DamageSource damageSource = event.getSource();
            if (!(damageSource instanceof JJKDamageSources.JujutsuDamageSource)) {
                return;
            }
            JJKDamageSources.JujutsuDamageSource source = (JJKDamageSources.JujutsuDamageSource)damageSource;
            LivingEntity victim = event.getEntity();
            if (!JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
                return;
            }
            Ability ability = source.getAbility();
            if (ability == null) {
                return;
            }
            if (ability.isTechnique()) {
                event.setAmount(event.getAmount() * (ability.getRequirements().contains(JJKAbilities.RCT1.get()) ? 0.8f : 0.85f));
            }
        }
    }
}

