/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.client.MixinData;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class MirageParticle<T extends MirageParticleOptions>
extends TextureSheetParticle {
    private final int entityId;
    @Nullable
    private Entity entity;
    private float yRot;
    private float yRot0;
    private float yHeadRot;
    private float yHeadRot0;
    private float yBodyRot;
    private float yBodyRotO;
    private float position;
    private float speed;

    protected MirageParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, T options) {
        super(pLevel, pX, pY, pZ);
        this.f_107225_ = 10;
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.entityId = ((MirageParticleOptions)options).entityId();
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        if (this.entity == null) {
            this.entity = this.f_107208_.m_6815_(this.entityId);
            if (this.entity == null) {
                return;
            }
            this.yRot = this.entity.m_146908_();
            this.yRot0 = this.entity.f_19859_;
            Entity entity = this.entity;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.yHeadRot = living.f_20885_;
                this.yHeadRot0 = living.f_20886_;
                this.yBodyRot = living.f_20883_;
                this.yBodyRotO = living.f_20884_;
                this.position = living.f_267362_.m_267756_();
                this.speed = living.f_267362_.m_267731_();
            }
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        if (this.entity != null) {
            PoseStack stack = new PoseStack();
            float yRot = this.entity.m_146908_();
            float yRotO = this.entity.f_19859_;
            float yHeadRot = 0.0f;
            float yHeadRotO = 0.0f;
            float yBodyRot = 0.0f;
            float yBodyRotO = 0.0f;
            boolean invisible = this.entity.m_20145_();
            MixinData.isFakeRender = true;
            MixinData.isCustomWalkAnimation = true;
            MixinData.walkAnimationPosition = this.position;
            MixinData.walkAnimationSpeed = this.speed;
            this.entity.m_6842_(false);
            Entity entity = this.entity;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                yHeadRot = living.f_20885_;
                yHeadRotO = living.f_20886_;
                living.f_20885_ = this.yHeadRot;
                living.f_20886_ = this.yHeadRot0;
                yBodyRot = living.f_20885_;
                yBodyRotO = living.f_20886_;
                living.f_20883_ = this.yBodyRot;
                living.f_20884_ = this.yBodyRotO;
            }
            this.entity.m_146922_(this.yRot);
            this.entity.f_19859_ = this.yRot0;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_107230_);
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            EntityRenderer renderer = manager.m_114382_(this.entity);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            Vec3 offset = renderer.m_7860_(this.entity, pPartialTicks);
            stack.m_85837_(this.f_107212_ - pRenderInfo.m_90583_().f_82479_ + offset.f_82479_, this.f_107213_ - pRenderInfo.m_90583_().f_82480_ + offset.f_82480_, this.f_107214_ - pRenderInfo.m_90583_().f_82481_ + offset.f_82481_);
            renderer.m_7392_(this.entity, 0.0f, pPartialTicks, stack, (MultiBufferSource)buffer, manager.m_114394_(this.entity, pPartialTicks));
            buffer.m_6299_(RenderType.m_110466_());
            buffer.m_109911_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entity.f_19859_ = yRotO;
            this.entity.m_146922_(yRot);
            Entity entity2 = this.entity;
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                living.f_20884_ = yBodyRotO;
                living.f_20883_ = yBodyRot;
                living.f_20886_ = yHeadRotO;
                living.f_20885_ = yHeadRot;
            }
            this.entity.m_6842_(invisible);
            MixinData.isCustomWalkAnimation = false;
            MixinData.isFakeRender = false;
        }
    }

    public record MirageParticleOptions(int entityId) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<MirageParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<MirageParticleOptions>(){

            @NotNull
            public MirageParticleOptions fromCommand(@NotNull ParticleType<MirageParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                return new MirageParticleOptions(reader.readInt());
            }

            @NotNull
            public MirageParticleOptions fromNetwork(@NotNull ParticleType<MirageParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new MirageParticleOptions(buf.readInt());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.MIRAGE.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeInt(this.entityId);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.entityId);
        }
    }

    public static class Provider
    implements ParticleProvider<MirageParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public Particle createParticle(@NotNull MirageParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new MirageParticle<MirageParticleOptions>(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType);
        }
    }
}

