/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.entity.effect.PiercingWaterEntity;

public class PiercingWaterRenderer
extends EntityRenderer<PiercingWaterEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/piercing_water.png");
    private static final int TEXTURE_WIDTH = 16;
    private static final int TEXTURE_HEIGHT = 512;
    private static final float BEAM_RADIUS = 0.1f;
    private static final float ALPHA = 0.5f;
    private boolean clearerView = false;

    public PiercingWaterRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PiercingWaterEntity pEntity) {
        return TEXTURE;
    }

    public void render(PiercingWaterEntity pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Entity owner = pEntity.m_19749_();
        this.clearerView = owner instanceof Player && Minecraft.m_91087_().f_91074_ == owner && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        double collidePosX = pEntity.prevCollidePosX + (pEntity.collidePosX - pEntity.prevCollidePosX) * (double)pPartialTick;
        double collidePosY = pEntity.prevCollidePosY + (pEntity.collidePosY - pEntity.prevCollidePosY) * (double)pPartialTick;
        double collidePosZ = pEntity.prevCollidePosZ + (pEntity.collidePosZ - pEntity.prevCollidePosZ) * (double)pPartialTick;
        double posX = pEntity.f_19854_ + (pEntity.m_20185_() - pEntity.f_19854_) * (double)pPartialTick;
        double posY = pEntity.f_19855_ + (pEntity.m_20186_() - pEntity.f_19855_) * (double)pPartialTick;
        double posZ = pEntity.f_19856_ + (pEntity.m_20189_() - pEntity.f_19856_) * (double)pPartialTick;
        float yaw = pEntity.prevYaw + (pEntity.renderYaw - pEntity.prevYaw) * pPartialTick;
        float pitch = pEntity.prevPitch + (pEntity.renderPitch - pEntity.prevPitch) * pPartialTick;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(pEntity.animation - 1) + pPartialTick) * 2.0f));
        if (frame < 0) {
            frame = pEntity.getFrames() * 2;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(pEntity.getScale(), pEntity.getScale(), pEntity.getScale());
        pPoseStack.m_252880_(0.0f, pEntity.m_20206_() / 2.0f, 0.0f);
        VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, pPoseStack, consumer, pPackedLight);
        pPoseStack.m_85849_();
    }

    private void drawCube(float length, int frame, PoseStack poseStack, VertexConsumer consumer, int packedLight) {
        float minU = 0.0f;
        float minV = 0.03125f * (float)frame;
        float maxU = minU + 1.0f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        float offset = this.clearerView ? -1.0f : 0.0f;
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, 0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, 0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, 0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, 0.1f, maxU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, -0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, -0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, -0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, -0.1f, maxU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, -0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, 0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, 0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, -0.1f, maxU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, -0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, 0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, 0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, -0.1f, maxU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, -0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, length, 0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, 0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, -0.1f, offset, -0.1f, maxU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, -0.1f, minU, minV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, length, 0.1f, minU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, 0.1f, maxU, maxV, 0.5f, packedLight);
        this.drawVertex(matrix4f, matrix3f, consumer, 0.1f, offset, -0.1f, maxU, minV, 0.5f, packedLight);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack poseStack, VertexConsumer consumer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(yaw - 90.0f));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(pitch));
        this.drawCube(length, frame, poseStack, consumer, packedLight);
        poseStack.m_85849_();
    }

    public void drawVertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer consumer, float x, float y, float z, float u, float v, float alpha, int packedLight) {
        consumer.m_252986_(matrix4f, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

