/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class KuchisakeOnnaEntity
extends CursedSpirit {
    public static final double RANGE = 16.0;
    private static final int SNIP_DURATION = 5;
    private static final float DAMAGE = 5.0f;
    private static final int INTERVAL = 60;
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation SNIP = RawAnimation.begin().thenPlay("attack.snip");
    public static EntityDataAccessor<Optional<UUID>> DATA_TARGET = SynchedEntityData.m_135353_(KuchisakeOnnaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static EntityDataAccessor<Boolean> DATA_OPEN = SynchedEntityData.m_135353_(KuchisakeOnnaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static EntityDataAccessor<Integer> DATA_SNIP = SynchedEntityData.m_135353_(KuchisakeOnnaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 start;
    private int cooldown;

    public KuchisakeOnnaEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean canChangeTarget() {
        return true;
    }

    @Override
    public boolean hasMeleeAttack() {
        return false;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22279_, 0.165).m_22268_(Attributes.f_22285_, 12.0);
    }

    private PlayState walkPredicate(AnimationState<KuchisakeOnnaEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(WALK);
        }
        return PlayState.STOP;
    }

    private PlayState cutPredicate(AnimationState<KuchisakeOnnaEntity> animationState) {
        if ((Integer)this.f_19804_.m_135370_(DATA_SNIP) > 0) {
            return animationState.setAndContinue(SNIP);
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk", this::walkPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Snip", this::cutPredicate)});
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TARGET, Optional.empty());
        this.f_19804_.m_135372_(DATA_OPEN, (Object)false);
        this.f_19804_.m_135372_(DATA_SNIP, (Object)0);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        Optional identifier;
        Entity source = pSource.m_7639_();
        if (source != null && (identifier = (Optional)this.f_19804_.m_135370_(DATA_TARGET)).isPresent() && source.m_20148_().equals(identifier.get())) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean isOpen() {
        return (Boolean)this.f_19804_.m_135370_(DATA_OPEN);
    }

    public Optional<UUID> getCurrent() {
        return (Optional)this.f_19804_.m_135370_(DATA_TARGET);
    }

    public void reset() {
        this.f_19804_.m_135381_(DATA_OPEN, (Object)false);
        this.f_19804_.m_135381_(DATA_TARGET, Optional.empty());
        if (JJKAbilities.hasToggled((LivingEntity)this, (Ability)JJKAbilities.SCISSORS.get())) {
            AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.SCISSORS.get());
        }
        this.start = null;
        this.cooldown = 60;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.SPECIAL_GRADE.getRequiredExperience();
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.SCISSORS.get());
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    public List<Ability> getUnlocked() {
        return List.of((Ability)JJKAbilities.SIMPLE_DOMAIN.get());
    }

    public void attack() {
        this.f_19804_.m_135381_(DATA_SNIP, (Object)5);
        AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.SCISSORS.get());
        this.getCurrent().ifPresent(identifier -> {
            Entity target = ((ServerLevel)this.m_9236_()).m_8791_(identifier);
            if (target == null) {
                return;
            }
            this.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> target.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack((LivingEntity)this, null), 5.0f * cap.getAbilityPower()));
        });
        this.reset();
    }

    @Override
    public void changeTarget(LivingEntity target) {
        if (target == null || target.m_213877_() || !target.m_6084_()) {
            return;
        }
        this.f_19804_.m_135381_(DATA_TARGET, Optional.of(target.m_20148_()));
        this.start = target.m_20182_();
        this.m_6710_(target);
    }

    @Override
    protected void m_8024_() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        int snip = (Integer)this.f_19804_.m_135370_(DATA_SNIP);
        if (snip > 0) {
            this.f_19804_.m_135381_(DATA_SNIP, (Object)(--snip));
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (!VeilHandler.getDomains((ServerLevel)this.m_9236_(), this.m_20183_()).isEmpty()) {
            this.reset();
            return;
        }
        this.getCurrent().ifPresent(identifier -> {
            Entity patt7762$temp = ((ServerLevel)this.m_9236_()).m_8791_(identifier);
            if (!(patt7762$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)patt7762$temp;
            this.f_21342_.m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.m_6113_());
            if ((double)this.m_20270_((Entity)target) > 16.0) {
                this.reset();
            } else if (Math.sqrt(target.m_20238_(this.start)) >= 3.0) {
                this.attack();
            }
        });
        LivingEntity target = this.m_5448_();
        if (target == null || target.m_213877_() || !target.m_6084_()) {
            return;
        }
        if (!this.isOpen()) {
            if (this.cooldown > 0) {
                return;
            }
            if ((double)this.m_20270_((Entity)target) <= 16.0) {
                this.f_19804_.m_135381_(DATA_TARGET, Optional.of(target.m_20148_()));
                this.start = target.m_20182_();
                if (((Ability)JJKAbilities.SCISSORS.get()).getStatus((LivingEntity)this) == Ability.Status.SUCCESS) {
                    target.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.kuchisake_onna", "jujutsu_kaisen"), (Object[])new Object[]{this.m_7755_().getString()}));
                    this.f_19804_.m_135381_(DATA_OPEN, (Object)true);
                } else {
                    this.f_19804_.m_135381_(DATA_TARGET, Optional.empty());
                }
            } else {
                this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)this.m_6113_());
            }
        }
    }
}

