/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.base.IJumpInputListener;
import radon.jujutsu_kaisen.entity.curse.RainbowDragonSegmentEntity;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RainbowDragonEntity
extends CursedSpirit
implements PlayerRideable,
IJumpInputListener {
    private static final RawAnimation BITE = RawAnimation.begin().thenPlay("attack.bite");
    private static final int MAX_IDLE_Y = 16;
    private static final int MAX_SEGMENTS = 12;
    public static final int ARMS = 1;
    public static final int LEGS = 7;
    public static final int TAIL = 12;
    private boolean jump;
    private final RainbowDragonSegmentEntity[] segments;

    public RainbowDragonEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.segments = new RainbowDragonSegmentEntity[12];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new RainbowDragonSegmentEntity(this, i);
            this.segments[i].m_7678_(this.m_20185_() + 0.1 * (double)i, this.m_20186_() + 0.5, this.m_20189_() + 0.1 * (double)i, this.f_19796_.m_188501_() * 360.0f, 0.0f);
        }
        this.m_20234_(f_19843_.getAndAdd(this.segments.length + 1) + 1);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_20234_(id + i + 1);
        }
    }

    private PlayState bitePredicate(AnimationState<RainbowDragonEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(BITE);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Bite", this::bitePredicate)});
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return true;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    public float getStepHeight() {
        return 2.0f;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.segments;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_) {
            for (RainbowDragonSegmentEntity seg : this.segments) {
                seg.m_6074_();
            }
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].m_8119_();
            RainbowDragonEntity leader = i == 0 ? this : this.segments[i - 1];
            Vec3 follow = leader.m_20182_();
            float angle = (leader.m_146908_() + 180.0f) * (float)Math.PI / 180.0f;
            double f = leader.m_20205_() / 2.0f + this.segments[i].m_20205_() / 2.0f;
            double force = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-Mth.m_14031_((float)angle)) * force;
            double idealZ = (double)Mth.m_14089_((float)angle) * force;
            double groundY = this.segments[i].m_5830_() ? follow.f_82480_ + f : follow.f_82480_;
            double idealY = (groundY - follow.f_82480_) * force;
            Vec3 diff = new Vec3(this.segments[i].m_20185_() - follow.f_82479_, this.segments[i].m_20186_() - follow.f_82480_, this.segments[i].m_20189_() - follow.f_82481_).m_82541_().m_82520_(idealX, idealY, idealZ).m_82541_();
            double destX = follow.f_82479_ + f * diff.f_82479_;
            double destY = follow.f_82480_ + f * diff.f_82480_;
            double destZ = follow.f_82481_ + f * diff.f_82481_;
            this.segments[i].m_6034_(destX, destY, destZ);
            double distance = Mth.m_14116_((float)((float)(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_)));
            this.segments[i].m_19915_((float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.f_82480_, distance) * 180.0 / Math.PI)));
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.m_20096_()) {
            return Vec3.f_82478_;
        }
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    public boolean m_20068_() {
        if (this.m_20160_()) {
            return false;
        }
        Vec3 offset = this.m_20182_().m_82492_(0.0, 16.0, 0.0);
        BlockHitResult hit = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        if (this.m_5448_() == null && hit.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        return super.m_20068_();
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        Vec3 movement = this.m_20184_();
        if (this.jump) {
            this.m_20256_(movement.m_82520_(0.0, (double)this.m_274460_(), 0.0));
        }
    }

    @Override
    public void setJump(boolean jump) {
        this.jump = jump;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        this.f_20885_ = this.m_146908_();
        this.moveSegments();
    }

    public boolean isMultipartEntity() {
        return this.segments != null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22266_(Attributes.f_22280_).m_22268_(Attributes.f_22284_, 50.0).m_22268_(Attributes.f_22281_, 30.0);
    }

    protected float m_274460_() {
        return this.m_5448_() == null || this.m_6109_() ? 0.15f : 1.8f;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.GRADE_1.getRequiredExperience();
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }
}

