/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class ProjectionFrameEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(ProjectionFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DURATION = 60;
    private static final float DAMAGE = 30.0f;
    @Nullable
    private UUID victimUUID;
    @Nullable
    private LivingEntity cachedVictim;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;
    private Vec3 pos;
    private float power;

    public ProjectionFrameEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public ProjectionFrameEntity(LivingEntity owner, LivingEntity target, float power) {
        this((EntityType)JJKEntities.PROJECTION_FRAME.get(), owner.m_9236_());
        this.setOwner(owner);
        this.setVictim(target);
        this.power = power;
        this.pos = target.m_20182_();
        this.m_7678_(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), target.m_146909_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128347_("pos_x", this.pos.f_82479_);
        pCompound.m_128347_("pos_y", this.pos.f_82480_);
        pCompound.m_128347_("pos_z", this.pos.f_82481_);
        if (this.victimUUID != null) {
            pCompound.m_128362_("victim", this.victimUUID);
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128350_("power", this.power);
        pCompound.m_128405_("time", this.getTime());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        this.pos = new Vec3(pCompound.m_128459_("pos_x"), pCompound.m_128459_("pos_y"), pCompound.m_128459_("pos_z"));
        if (pCompound.m_128403_("victim")) {
            this.victimUUID = pCompound.m_128342_("victim");
        }
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.power = pCompound.m_128457_("power");
        this.setTime(pCompound.m_128451_("time"));
    }

    public float getPower() {
        return this.power;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * ProjectionFrameEntity.m_20150_()) * d0;
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        LivingEntity victim = this.getVictim();
        if (!this.m_9236_().f_46443_ && (victim == null || victim.m_213877_() || victim.m_21224_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (this.getTime() >= 60) {
                this.m_146870_();
            } else if (victim != null) {
                victim.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 2, 1, false, false, false));
                if (this.pos != null) {
                    victim.m_6021_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
                }
            }
        }
    }

    public void setVictim(@Nullable LivingEntity victim) {
        if (victim != null) {
            this.victimUUID = victim.m_20148_();
            this.cachedVictim = victim;
        }
    }

    @Nullable
    public LivingEntity getVictim() {
        if (this.cachedVictim != null && !this.cachedVictim.m_213877_()) {
            return this.cachedVictim;
        }
        if (this.victimUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedVictim = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.victimUUID);
            return this.cachedVictim;
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getVictim();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity victim = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (victim != null) {
            this.setVictim(victim);
        }
    }
}

