/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public abstract class BeamEntity
extends JujutsuProjectile {
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public boolean on = true;
    @Nullable
    public Direction side = null;
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float prevYaw;
    public float prevPitch;
    public int animation;

    protected BeamEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
        this.update();
    }

    protected BeamEntity(EntityType<? extends Projectile> pType, LivingEntity owner, float power) {
        this(pType, owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
    }

    public abstract int getFrames();

    public abstract float getScale();

    protected abstract double getRange();

    protected abstract float getDamage();

    protected abstract int getDuration();

    public abstract int getCharge();

    protected boolean causesFire() {
        return false;
    }

    protected boolean causesElec() {
        return false;
    }

    protected boolean isStill() {
        return false;
    }

    protected boolean shouldSwing() {
        return true;
    }

    @Nullable
    protected abstract Ability getSource();

    protected Vec3 calculateSpawnPos(LivingEntity owner) {
        return new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner));
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.update();
        this.calculateEndPos();
        this.checkCollisions(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (!this.isStill()) {
            this.update();
        }
        if ((entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.shouldSwing() && this.getTime() % 5 == 0) {
                owner.m_6674_(InteractionHand.MAIN_HAND);
            }
            if (!this.on && this.animation == 0) {
                this.m_146870_();
            }
            if (this.getFrames() > 0) {
                if (this.on) {
                    if (this.animation < this.getFrames()) {
                        ++this.animation;
                    }
                } else if (this.animation > 0) {
                    --this.animation;
                }
            }
            if (this.getTime() >= this.getCharge()) {
                if (!this.isStill()) {
                    this.calculateEndPos();
                }
                List<Entity> entities = this.checkCollisions(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
                for (Entity entity2 : entities) {
                    if (entity2 == owner || !entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, this.getSource()), this.getDamage() * this.getPower()) || !this.causesFire()) continue;
                    entity2.m_20254_(5);
                }
                if (!this.m_9236_().f_46443_) {
                    double radius = this.getScale() * 2.0f;
                    AABB bounds = new AABB(this.collidePosX - radius, this.collidePosY - radius, this.collidePosZ - radius, this.collidePosX + radius, this.collidePosY + radius, this.collidePosZ + radius);
                    double centerX = bounds.m_82399_().f_82479_;
                    double centerY = bounds.m_82399_().f_82480_;
                    double centerZ = bounds.m_82399_().f_82481_;
                    int x = (int)bounds.f_82288_;
                    while ((double)x <= bounds.f_82291_) {
                        int y = (int)bounds.f_82289_;
                        while ((double)y <= bounds.f_82292_) {
                            int z = (int)bounds.f_82290_;
                            while ((double)z <= bounds.f_82293_) {
                                BlockPos pos = new BlockPos(x, y, z);
                                double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                                if (!(distance > radius)) {
                                    if (HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos)) {
                                        this.m_9236_().m_46961_(pos, false);
                                    } else if (this.causesFire() && this.f_19796_.m_188503_(3) == 0 && this.m_9236_().m_8055_(pos).m_60795_() && this.m_9236_().m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.m_9236_(), pos.m_7495_())) {
                                        this.m_9236_().m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)pos));
                                    }
                                    if (this.causesElec()) {
                                        int count = this.f_19796_.m_188503_(16);
                                        for (int i = 0; i < count; ++i) {
                                            double px = (double)x + (HelperMethods.RANDOM.m_188500_() - 0.5);
                                            double py = (double)y + HelperMethods.RANDOM.m_188500_();
                                            double pz = (double)z + (HelperMethods.RANDOM.m_188500_() - 0.5);
                                            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 5), px, py, pz, 0, 0.0, 0.0, 0.0, 0.0);
                                        }
                                    }
                                }
                                ++z;
                            }
                            ++y;
                        }
                        ++x;
                    }
                }
            }
            if (this.getTime() - this.getCharge() >= this.getDuration()) {
                this.on = false;
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH, (Object)Float.valueOf(0.0f));
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(DATA_PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(DATA_PITCH, (Object)Float.valueOf(pitch));
    }

    private void calculateEndPos() {
        if (this.m_9236_().f_46443_) {
            this.endPosX = this.m_20185_() + this.getRange() * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.m_20189_() + this.getRange() * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.m_20186_() + this.getRange() * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.m_20185_() + this.getRange() * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + this.getRange() * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + this.getRange() * Math.sin(this.getPitch());
        }
    }

    public List<Entity> checkCollisions(Vec3 from, Vec3 to) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = result.m_82450_();
            this.collidePosX = pos.f_82479_;
            this.collidePosY = pos.f_82480_;
            this.collidePosZ = pos.f_82481_;
            this.side = result.m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.side = null;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        AABB bounds = new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82400_((double)this.getScale() * 1.5);
        for (Entity entity : this.m_9236_().m_45933_(this.m_19749_(), bounds)) {
            float pad = entity.m_6143_() + 1.25f;
            AABB padded = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = padded.m_82371_(from, to);
            if (padded.m_82390_(from)) {
                entities.add(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    private void update() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.renderYaw = (float)(((double)RotationUtil.getTargetAdjustedYRot((Entity)owner) + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-RotationUtil.getTargetAdjustedXRot((Entity)owner)) * Math.PI / 180.0);
            this.setYaw((float)((double)(RotationUtil.getTargetAdjustedYRot((Entity)owner) + 90.0f) * Math.PI / 180.0));
            this.setPitch((float)((double)(-RotationUtil.getTargetAdjustedXRot((Entity)owner)) * Math.PI / 180.0));
            Vec3 spawn = this.calculateSpawnPos(owner);
            this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        }
    }
}

