/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.HashSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.LivingHitByDomainEvent;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.ten_shadows.MahoragaEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class AdaptationEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class AdaptationEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingHitByDomain(LivingHitByDomainEvent event) {
            LivingEntity victim = event.getEntity();
            if (!JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.WHEEL.get())) {
                return;
            }
            ITenShadowsData cap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.isAdaptedTo(event.getAbility())) {
                cap.tryAdapt(event.getAbility());
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            if (JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()) || !JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.WHEEL.get())) {
                return;
            }
            ITenShadowsData cap = (ITenShadowsData)victim.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.isAdaptedTo(source)) {
                cap.tryAdapt(source);
            }
            if (victim instanceof MahoragaEntity) {
                if (cap.isAdaptedTo(source)) {
                    victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12346_, SoundSource.MASTER, 1.0f, 1.0f);
                }
                float process = 1.0f - cap.getAdaptationProgress(source);
                switch (cap.getAdaptationType(source)) {
                    case DAMAGE: {
                        event.setAmount(event.getAmount() * process);
                        break;
                    }
                    case COUNTER: {
                        Entity attacker;
                        if (HelperMethods.RANDOM.m_188503_(Math.max(1, Math.round(20.0f * process))) != 0 || (attacker = source.m_7639_()) == null) break;
                        victim.m_7618_(EntityAnchorArgument.Anchor.EYES, attacker.m_20182_());
                        victim.m_6674_(InteractionHand.MAIN_HAND);
                        if (!victim.m_7327_(attacker)) break;
                        victim.f_19802_ = 0;
                    }
                }
            }
        }

        @SubscribeEvent(receiveCanceled=true)
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (!attacker.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ITenShadowsData attackerCap = (ITenShadowsData)attacker.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.WHEEL.get())) {
                if (victimCap.hasToggled((Ability)JJKAbilities.INFINITY.get())) {
                    attackerCap.tryAdapt((Ability)JJKAbilities.INFINITY.get());
                }
                if (victimCap.hasToggled((Ability)JJKAbilities.SOUL_REINFORCEMENT.get())) {
                    attackerCap.tryAdapt((Ability)JJKAbilities.SOUL_REINFORCEMENT.get());
                }
            }
            if (!event.isCanceled() && attacker instanceof MahoragaEntity) {
                HashSet<Ability> toggled = new HashSet<Ability>(victimCap.getToggled());
                for (Ability ability : toggled) {
                    if (!attackerCap.isAdaptedTo(ability)) continue;
                    victimCap.toggle(ability);
                }
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(victimCap.serializeNBT()), player);
                }
            }
        }
    }
}

