/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.capability.data.sorcerer.BindingVow;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.world.dimension.JJKDimensions;

public class PactEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class PactEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            ISorcererData cap;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (source.m_276093_(JJKDamageSources.JUJUTSU) && attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent() && (cap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).hasBindingVow(BindingVow.RECOIL)) {
                attacker.m_6469_(JJKDamageSources.self(victim), event.getAmount() * 0.25f);
                event.setAmount(event.getAmount() * 1.15f);
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            TamableAnimal tamable;
            LivingEntity attacker;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                attacker = (LivingEntity)entity;
            } else {
                return;
            }
            while (attacker instanceof TamableAnimal && (tamable = (TamableAnimal)attacker).m_21824_()) {
                attacker = tamable.m_269323_();
                if (attacker != null) continue;
                return;
            }
            while (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21824_()) {
                victim = tamable.m_269323_();
                if (victim != null) continue;
                return;
            }
            if (victim.getCapability(SorcererDataHandler.INSTANCE).isPresent() && attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                ISorcererData attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (victimCap.hasPact(attacker.m_20148_(), Pact.INVULNERABILITY) && attackerCap.hasPact(victim.m_20148_(), Pact.INVULNERABILITY)) {
                    ServerLevel dimension;
                    victimCap.removePact(attacker.m_20148_(), Pact.INVULNERABILITY);
                    attackerCap.removePact(victim.m_20148_(), Pact.INVULNERABILITY);
                    MinecraftServer server = attacker.m_9236_().m_7654_();
                    if (server != null && (dimension = server.m_129880_(JJKDimensions.LIMBO_KEY)) != null) {
                        BlockPos pos = HelperMethods.findSafePos(dimension, attacker);
                        attacker.m_264318_(dimension, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Set.of(), attacker.m_146908_(), attacker.m_146909_());
                    }
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(victimCap.serializeNBT()), (ServerPlayer)victim);
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(attackerCap.serializeNBT()), (ServerPlayer)attacker);
                }
            }
        }
    }
}

