/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.veil.modifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import radon.jujutsu_kaisen.item.veil.modifier.ColorModifier;
import radon.jujutsu_kaisen.item.veil.modifier.CurseModifier;
import radon.jujutsu_kaisen.item.veil.modifier.GriefingModifier;
import radon.jujutsu_kaisen.item.veil.modifier.Modifier;
import radon.jujutsu_kaisen.item.veil.modifier.PlayerModifier;
import radon.jujutsu_kaisen.item.veil.modifier.SorcererModifier;
import radon.jujutsu_kaisen.item.veil.modifier.TransparentModifier;

public class ModifierUtils {
    private static final int MAX_MODIFIERS = 8;

    public static Modifier resolve(CompoundTag nbt) {
        Modifier.Type type = Modifier.Type.values()[nbt.m_128451_("type")];
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Modifier.Type.NONE -> new Modifier(nbt);
            case Modifier.Type.PLAYER -> new PlayerModifier(nbt);
            case Modifier.Type.COLOR -> new ColorModifier(nbt);
            case Modifier.Type.TRANSPARENT -> new TransparentModifier(nbt);
            case Modifier.Type.CURSE -> new CurseModifier(nbt);
            case Modifier.Type.SORCERER -> new SorcererModifier(nbt);
            case Modifier.Type.GRIEFING -> new GriefingModifier(nbt);
        };
    }

    public static List<Modifier> getModifiers(CompoundTag nbt) {
        if (!nbt.m_128441_("modifiers")) {
            return List.of();
        }
        ListTag modifiersTag = nbt.m_128437_("modifiers", 10);
        return ModifierUtils.deserialize(modifiersTag);
    }

    public static void setModifier(CompoundTag nbt, int index, Modifier modifier) {
        ListTag modifiersTag;
        if (!nbt.m_128441_("modifiers")) {
            modifiersTag = new ListTag();
            for (int i = 0; i < 8; ++i) {
                modifiersTag.add((Object)new Modifier(Modifier.Type.NONE, Modifier.Action.NONE).serialize());
            }
            nbt.m_128365_("modifiers", (Tag)modifiersTag);
        }
        modifiersTag = nbt.m_128437_("modifiers", 10);
        modifiersTag.set(index, (Tag)modifier.serialize());
    }

    public static List<Modifier> deserialize(ListTag modifiersTag) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        for (Tag tag : modifiersTag) {
            CompoundTag modifier = (CompoundTag)tag;
            modifiers.add(ModifierUtils.resolve(modifier));
        }
        return modifiers;
    }

    public static ListTag serialize(List<Modifier> modifiers) {
        ListTag modifiersTag = new ListTag();
        for (Modifier modifier : modifiers) {
            modifiersTag.add((Object)modifier.serialize());
        }
        return modifiersTag;
    }
}

