/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.effect.BlackFlashEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.RabbitEscapeEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.PlayerUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class BlackFlashHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BlackFlashHandlerForgeEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingDamage(LivingDamageEvent event) {
            ISorcerer sorcerer;
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!HelperMethods.isMelee(source)) {
                return;
            }
            if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimcap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (attacker instanceof ISorcerer && !(sorcerer = (ISorcerer)attacker).hasArms()) {
                return;
            }
            if (SorcererUtil.getGrade(cap.getExperience()).ordinal() < SorcererGrade.SEMI_GRADE_2.ordinal() || !(source instanceof JJKDamageSources.JujutsuDamageSource) && !cap.hasToggled((Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) && !cap.hasToggled((Ability)JJKAbilities.BLUE_FISTS.get())) {
                return;
            }
            long lastBlackFlashTime = cap.getLastBlackFlashTime();
            int seconds = (int)(attacker.m_9236_().m_46467_() - lastBlackFlashTime) / 20;
            if (lastBlackFlashTime == 0L || seconds >= 1) {
                Player player;
                int rng = (Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get();
                if (cap.addBlackFlash()) {
                    rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.75f);
                    if (cap.hasToggled((Ability)JJKAbilities.RATIO_RULE.get())) {
                        rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.1f);
                    }
                }
                if (cap.getNature() == CursedEnergyNature.DIVERGENT) {
                    rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.75f);
                    if (cap.addBlackFlash()) {
                        rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.5f);
                    }
                }
                if (attacker instanceof Player) {
                    player = (Player)attacker;
                    if (cap.isInZone()) {
                        rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.15f);
                        if (cap.getNature() == CursedEnergyNature.DIVERGENT) {
                            rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.1f);
                        }
                        if (cap.addBlackFlash()) {
                            rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.075f);
                            if (cap.getNature() == CursedEnergyNature.DIVERGENT) {
                                rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.05f);
                            }
                            if (cap.hasToggled((Ability)JJKAbilities.RATIO_RULE.get())) {
                                rng = Math.round(((Integer)ConfigHolder.SERVER.blackFlashChanceRNG.get()).floatValue() * 0.015f);
                            }
                        }
                    }
                }
                if (attacker instanceof ServerPlayer && !PlayerUtil.hasAdvancement((ServerPlayer)(player = (ServerPlayer)attacker), "black_flash") && cap.hasTrait(Trait.PRODIGY)) {
                    rng = (int)((double)rng / 1.5);
                }
                if (victimcap.getType() == JujutsuType.SHIKIGAMI) {
                    CursedSpirit curse;
                    rng = (int)((double)rng * 1.5);
                    if (victim instanceof RabbitEscapeEntity) {
                        rng = (int)((double)rng * 20.0);
                    } else if (victimcap.getType() == JujutsuType.CURSE && victim instanceof CursedSpirit && (curse = (CursedSpirit)victim).m_21824_()) {
                        rng = (int)((double)rng * 1.5);
                    }
                }
                if (cap.hasToggled((Ability)JJKAbilities.QUICK_DRAW.get())) {
                    rng = (int)((double)rng * 1.5);
                }
                if (rng >= 1 && HelperMethods.RANDOM.m_188503_(rng) != 0) {
                    return;
                }
            } else {
                return;
            }
            cap.onBlackFlash();
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
            event.setAmount(Math.min(((Double)ConfigHolder.SERVER.blackFlashDmgCap.get()).floatValue(), (float)Math.pow(event.getAmount(), ((Double)ConfigHolder.SERVER.blackFlashPower.get()).floatValue())));
            attacker.m_9236_().m_7967_((Entity)new BlackFlashEntity(attacker, victim));
            victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12090_, SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
            victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12089_, SoundSource.MASTER, 1.0f, 0.5f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        }
    }
}

