/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.block.entity.VeilBlockEntity;
import radon.jujutsu_kaisen.block.entity.VeilRodBlockEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.item.veil.modifier.Modifier;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VeilHandler {
    private static final Map<ResourceKey<Level>, Set<VeilRodBlockEntity>> veilsByDimension = new HashMap<ResourceKey<Level>, Set<VeilRodBlockEntity>>();
    private static final Map<ResourceKey<Level>, Set<UUID>> domains = new HashMap<ResourceKey<Level>, Set<UUID>>();

    public static boolean checkIntersect(Level level, BlockPos center, int radius) {
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(level.m_46472_());
        if (rods == null) {
            return false;
        }
        for (VeilRodBlockEntity rod : rods) {
            BlockPos otherPos = rod.m_58899_();
            if (!rod.isValid() || otherPos.equals((Object)center)) continue;
            int otherRadius = rod.getSize();
            double dist = Math.sqrt(center.m_123331_((Vec3i)otherPos));
            if (!(dist <= (double)(radius + otherRadius)) || !(dist >= (double)Math.abs(radius - otherRadius))) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(VeilRodBlockEntity rod) {
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(rod.m_58904_().m_46472_());
        return rods != null && rods.contains((Object)rod);
    }

    public static void addVeil(VeilRodBlockEntity rod) {
        ResourceKey dimension = rod.m_58904_().m_46472_();
        veilsByDimension.computeIfAbsent((ResourceKey<Level>)dimension, k -> new HashSet()).add(rod);
    }

    public static void removeVeil(VeilRodBlockEntity rod) {
        ResourceKey dimension = rod.m_58904_().m_46472_();
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(dimension);
        if (rods == null) {
            return;
        }
        rods.remove((Object)rod);
        int radius = rod.getSize();
        BlockPos center = rod.m_58899_();
        Level level = rod.m_58904_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    VeilBlockEntity veil;
                    BlockPos parent;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockEntity be = level.m_7702_(pos);
                    if (!(be instanceof VeilBlockEntity) || (parent = (veil = (VeilBlockEntity)be).getParent()) == null || !parent.equals((Object)center)) continue;
                    veil.destroy();
                }
            }
        }
        if (rods.isEmpty()) {
            veilsByDimension.remove(dimension);
        }
    }

    public static void addDomain(ResourceKey<Level> dimension, UUID id) {
        domains.computeIfAbsent(dimension, k -> new HashSet()).add(id);
    }

    public static Set<DomainExpansionEntity> getDomains(ServerLevel level) {
        HashSet<DomainExpansionEntity> result = new HashSet<DomainExpansionEntity>();
        Set<UUID> ids = domains.get(level.m_46472_());
        if (ids == null) {
            return result;
        }
        for (UUID id : ids) {
            Entity entity = level.m_8791_(id);
            if (!(entity instanceof DomainExpansionEntity)) continue;
            DomainExpansionEntity domain = (DomainExpansionEntity)entity;
            result.add(domain);
        }
        return result;
    }

    public static Set<DomainExpansionEntity> getDomains(ServerLevel level, BlockPos pos) {
        HashSet<DomainExpansionEntity> result = new HashSet<DomainExpansionEntity>();
        Set<UUID> ids = domains.get(level.m_46472_());
        if (ids == null) {
            return result;
        }
        for (UUID id : ids) {
            DomainExpansionEntity domain;
            Entity entity = level.m_8791_(id);
            if (!(entity instanceof DomainExpansionEntity) || !(domain = (DomainExpansionEntity)entity).isInsideBarrier(pos)) continue;
            result.add(domain);
        }
        return result;
    }

    public static Set<DomainExpansionEntity> getDomains(ServerLevel level, AABB bounds) {
        HashSet<DomainExpansionEntity> result = new HashSet<DomainExpansionEntity>();
        Set<UUID> ids = domains.get(level.m_46472_());
        if (ids == null) {
            return result;
        }
        for (UUID id : ids) {
            DomainExpansionEntity domain;
            Entity entity = level.m_8791_(id);
            if (!(entity instanceof DomainExpansionEntity) || !bounds.m_82381_((domain = (DomainExpansionEntity)entity).getBounds())) continue;
            result.add(domain);
        }
        return result;
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Set<UUID> current = domains.get(event.getLevel().m_46472_());
        if (current != null) {
            current.remove(event.getEntity().m_20148_());
            if (current.isEmpty()) {
                domains.remove(event.getLevel().m_46472_());
            }
        }
    }

    public static boolean canSpawn(Mob mob, double x, double y, double z) {
        BlockPos target = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(mob.m_9236_().m_46472_());
        if (rods == null) {
            return true;
        }
        for (VeilRodBlockEntity rod : Set.copyOf(rods)) {
            if (!rod.isValid()) continue;
            int radius = rod.getSize();
            boolean curseSpawnFlag = false;
            boolean sorcererSpawnFlag = false;
            for (Modifier modifier : rod.modifiers) {
                if (modifier.getAction() == Modifier.Action.ALLOW && modifier.getType() == Modifier.Type.CURSE_SPAWN) {
                    curseSpawnFlag = true;
                    continue;
                }
                if (modifier.getAction() != Modifier.Action.ALLOW || modifier.getType() != Modifier.Type.SORCERER_SPAWN) continue;
                sorcererSpawnFlag = true;
            }
            if (!(target.m_123331_((Vec3i)rod.m_58899_()) <= (double)(radius * radius)) || sorcererSpawnFlag && mob instanceof SorcererEntity || curseSpawnFlag && mob instanceof CursedSpirit) continue;
            return false;
        }
        return true;
    }

    public static boolean canDestroy(LivingEntity entity, Level level, double x, double y, double z) {
        return VeilHandler.canDestroy(entity, level, x, y, z, false);
    }

    public static boolean canDestroy(LivingEntity entity, Level level, double x, double y, double z, boolean manualBreak) {
        BlockPos target = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(level.m_46472_());
        if (rods == null) {
            return true;
        }
        for (VeilRodBlockEntity rod : Set.copyOf(rods)) {
            if (!rod.isValid() || manualBreak && target.equals((Object)rod.m_58899_())) continue;
            int radius = rod.getSize();
            if (target.m_123331_((Vec3i)rod.m_58899_()) >= (double)(radius * radius)) continue;
            boolean ownerFlag = false;
            boolean destroyFlag = true;
            for (Modifier modifier : rod.modifiers) {
                if (modifier.getAction() == Modifier.Action.ALLOW && modifier.getType() == Modifier.Type.OWNER_BYPASS) {
                    ownerFlag = true;
                    continue;
                }
                if (modifier.getAction() != Modifier.Action.DENY || modifier.getType() != Modifier.Type.GRIEFING) continue;
                destroyFlag = false;
            }
            if (ownerFlag && entity != null && rod.ownerUUID != null && rod.ownerUUID.equals(entity.m_20148_())) continue;
            return destroyFlag;
        }
        return true;
    }

    public static boolean isProtected(Level level, BlockPos target) {
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(level.m_46472_());
        if (rods == null) {
            return false;
        }
        for (VeilRodBlockEntity rod : Set.copyOf(rods)) {
            if (!rod.isValid()) continue;
            int radius = rod.getSize();
            if (!(target.m_123331_((Vec3i)rod.m_58899_()) < (double)(radius * radius))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTeleportValid(Level level, BlockPos target) {
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(level.m_46472_());
        if (rods == null) {
            return true;
        }
        for (VeilRodBlockEntity rod : Set.copyOf(rods)) {
            if (!rod.isValid()) continue;
            boolean ownerFlag = false;
            boolean teleportFlag = false;
            for (Modifier modifier : rod.modifiers) {
                if (modifier.getAction() == Modifier.Action.ALLOW && modifier.getType() == Modifier.Type.OWNER_BYPASS) {
                    ownerFlag = true;
                    continue;
                }
                if (modifier.getAction() != Modifier.Action.DENY || modifier.getType() != Modifier.Type.TELEPORT) continue;
                teleportFlag = true;
            }
            int radius = rod.getSize();
            if (!teleportFlag || !(target.m_123331_((Vec3i)rod.m_58899_()) <= (double)((radius + 2) * (radius + 2))) || ownerFlag) continue;
            return false;
        }
        return true;
    }

    public static void cleanupDimension(ResourceKey<Level> dimension) {
        Set<VeilRodBlockEntity> rods = veilsByDimension.get(dimension);
        if (rods == null) {
            return;
        }
        rods.removeIf(rod -> !rod.isValid());
        if (rods.isEmpty()) {
            veilsByDimension.remove(dimension);
        }
    }
}

