/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.FishCurseEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class FishSwarm
extends Ability {
    public static final double RANGE = 80.0;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        return HelperMethods.RANDOM.m_188503_(40) == 0 && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        if (!super.isValid(owner)) {
            return false;
        }
        ISorcererData cap = owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        return cap.hasCurse((EntityType)JJKEntities.FISH_CURSE.get());
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        EntityHitResult hit;
        HitResult hitResult = RotationUtil.getLookAtHit((Entity)owner, 80.0);
        if (hitResult instanceof EntityHitResult && (hitResult = (hit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitResult;
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Entity entity;
            AbsorbedCurse curse = cap.getCurse((EntityType)JJKEntities.FISH_CURSE.get());
            if (curse == null || curse.equals(null) || !((entity = JJKAbilities.summonCurse(owner, curse, false)) instanceof FishCurseEntity)) {
                return;
            }
            FishCurseEntity fish = (FishCurseEntity)entity;
            Vec3 start = owner.m_146892_();
            fish.m_146884_(start.m_82520_((double)(-4 + i), 4.0, 1.0));
            Vec3 velocity = target.m_20182_().m_82546_(owner.m_20182_()).m_82541_().m_82490_(2.5);
            fish.m_20256_(velocity);
            fish.m_6710_(target);
        }
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return 0.0f;
        }
        AbsorbedCurse curse = cap.getCurse((EntityType)JJKEntities.FISH_CURSE.get());
        return curse == null ? 0.0f : JJKAbilities.getCurseCost(curse);
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

