/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.curse.AbsorbedPlayerEntity;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ReleaseCurses
extends Ability {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target == null;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static void makePoofParticles(Entity entity) {
        for (int i = 0; i < 20; ++i) {
            double d0 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d1 = HelperMethods.RANDOM.m_188583_() * 0.02;
            double d2 = HelperMethods.RANDOM.m_188583_() * 0.02;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0, d0, d1, d2, 1.0);
        }
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity summon : ownerCap.getSummons()) {
            if (!(summon instanceof CursedSpirit)) continue;
            CursedSpirit curse = (CursedSpirit)summon;
            ownerCap.removeSummon((Entity)curse);
            ISorcererData curseCap = (ISorcererData)curse.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (curse instanceof AbsorbedPlayerEntity) {
                AbsorbedPlayerEntity absorbed = (AbsorbedPlayerEntity)curse;
                ownerCap.addCurse(new AbsorbedCurse(curse.m_7755_(), curse.m_6095_(), curseCap.serializeNBT(), absorbed.getPlayer()));
            } else {
                ownerCap.addCurse(new AbsorbedCurse(curse.m_7755_(), curse.m_6095_(), curseCap.serializeNBT()));
            }
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(ownerCap.serializeNBT()), player);
            }
            if (!owner.m_9236_().f_46443_) {
                ReleaseCurses.makePoofParticles((Entity)curse);
            }
            curse.m_146870_();
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }
}

