/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.cursed_speech;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.cursed_speech.CursedSpeech;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.client.particle.CursedSpeechParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Explode
extends CursedSpeech {
    private static final double RANGE = 30.0;
    private static final double RADIUS = 2.5;
    private static final float EXPLOSIVE_POWER = 3.5f;
    private static final float MAX_EXPLOSIVE_POWER = 15.0f;
    double REALRADIUS = 2.5;
    double REALRANGE = 30.0;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return this.getEntities((LivingEntity)owner).contains(target) && target != null && (owner.m_21223_() / owner.m_21233_() <= 0.5f || HelperMethods.RANDOM.m_188503_(10) == 0 && owner.m_142582_((Entity)target));
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private List<Entity> getEntities(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        if (ChantHandler.isChanted(owner, this)) {
            float output = ChantHandler.getOutput(owner, this);
            this.REALRANGE = 30.0 * (double)output;
            this.REALRADIUS = 2.5 * (double)output;
            AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(this.REALRANGE)).m_82400_(this.REALRADIUS);
            return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
                LivingEntity living;
                return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
            });
        }
        AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(30.0)).m_82400_(2.5);
        return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
            LivingEntity living;
            return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
        });
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        int i = 1;
        while ((double)i < this.REALRANGE + 7.0) {
            Vec3 dst = src.m_82549_(look.m_82490_((double)i));
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new CursedSpeechParticle.CursedSpeechParticleOptions(new Vector3f(1.0f, 0.965f, 0.176f), (float)(src.m_82554_(dst) * 0.5)), dst.f_82479_, dst.f_82480_, dst.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.CURSED_SPEECH.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity entity : this.getEntities(owner)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || JJKAbilities.hasToggled(living = (LivingEntity)entity, (Ability)JJKAbilities.INFINITY.get())) continue;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.explode", "jujutsu_kaisen"), (Object[])new Object[]{owner.m_7755_()}));
            }
            cap.delayTickEvent(() -> {
                if (entity != null) {
                    ExplosionHandler.spawn((ResourceKey<Level>)owner.m_9236_().m_46472_(), entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0), Math.min(15.0f, 3.5f * this.getPower(owner) * 1.05f), 20, this.getPower(owner) * 0.28f, owner, JJKDamageSources.jujutsuAttack(owner, this), false);
                }
            }, 15);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 150.0f;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public int getThroatDamage() {
        return 60;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.CURSED_SPEECH;
    }
}

