/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_flames;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.effect.MeteorEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class MaximumMeteor
extends Ability {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ISorcererData targetcap = target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
        if (targetcap == null) {
            return false;
        }
        if (SorcererUtil.getGrade(targetcap.getExperience()).ordinal() > SorcererGrade.GRADE_1.ordinal()) {
            return owner.m_142582_((Entity)target) && !JJKAbilities.hasToggled((LivingEntity)owner, (Ability)JJKAbilities.COFFIN_OF_THE_IRON_MOUNTAIN.get()) && (cap.getType() == JujutsuType.CURSE && HelperMethods.RANDOM.m_188503_(10) == 0 || cap.isUnlocked((Ability)JJKAbilities.RCT1.get()) ? owner.m_21223_() / owner.m_21233_() < 0.6f : owner.m_21223_() / owner.m_21233_() < 0.4f);
        }
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static boolean canSpawn(LivingEntity owner, float power) {
        Vec3 offset = owner.m_20182_().m_82520_(0.0, (double)(20 + MeteorEntity.getSize(power)), 0.0);
        BlockHitResult hit = owner.m_9236_().m_45547_(new ClipContext(owner.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return hit.m_6662_() != HitResult.Type.BLOCK;
    }

    @Override
    public void run(LivingEntity owner) {
        if (MaximumMeteor.canSpawn(owner, this.getPower(owner))) {
            owner.m_6674_(InteractionHand.MAIN_HAND);
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.SPARK.get(), SoundSource.MASTER, 2.0f, 1.0f);
            MeteorEntity meteor = new MeteorEntity(owner, this.getPower(owner));
            owner.m_9236_().m_7967_((Entity)meteor);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 800.0f;
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.maximumMeteorCost.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(0.0f, 3.0f);
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return (technique == CursedTechnique.DISASTER_FLAMES || cap.hasStolen(CursedTechnique.DISASTER_FLAMES)) && super.isDisplayed(owner);
    }

    @Override
    public int getCooldown() {
        return 1200;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        if (owner.m_21023_((MobEffect)JJKEffects.STUN.get()) || !MaximumMeteor.canSpawn(owner, this.getPower(owner))) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.FIRE;
    }
}

