/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.effect.ForestDashEntity;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ForestDash
extends Ability
implements Ability.IChannelened {
    private static final double SPEED = 2.5;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && !target.m_21224_() && (double)owner.m_20270_((Entity)target) >= 3.0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 start = owner.m_20182_().m_82546_(owner.m_20289_(0.1f).m_82490_(2.0));
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getEnergy() <= 6.0f) {
            return;
        }
        for (double i = 0.0; i <= 5.0; i += 2.0) {
            Vec3 offset = start.m_82549_(look.m_82490_(i));
            ForestDashEntity forest = new ForestDashEntity(owner);
            forest.m_7678_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_(), 180.0f - RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
            owner.m_9236_().m_7967_((Entity)forest);
        }
        owner.m_20256_(look.m_82490_(2.5));
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 6.0f;
    }

    @Override
    public int getCooldown() {
        return 40;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

