/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.limitless;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.projectile.HollowPurpleProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class HollowPurple
extends Ability {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        ISorcererData cap = target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        if (SorcererUtil.getGrade(cap.getExperience()).ordinal() > SorcererGrade.GRADE_1.ordinal()) {
            return (double)owner.m_20270_((Entity)target) >= 20.0 && HelperMethods.RANDOM.m_188503_(3) == 0;
        }
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        HollowPurpleProjectile purple = new HollowPurpleProjectile(owner, this.getPower(owner));
        owner.m_9236_().m_7967_((Entity)purple);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.setDisarmed(40);
    }

    @Override
    public List<Ability> getRequirements() {
        return List.of((Ability)JJKAbilities.RCT1.get());
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 800.0f;
    }

    @Override
    public int getCooldown() {
        return 600;
    }
}

