/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shrine;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.JJKParticles;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;

public class Cleave
extends Ability
implements Ability.IDomainAttack,
Ability.IAttack,
Ability.IToggled {
    public static final double RANGE = 30.0;
    private static final float DAMAGE = 30.0f;
    private static final float DAMAGE_SCALE = 0.05f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    private DamageSource getSource(LivingEntity owner, @Nullable DomainExpansionEntity domain) {
        return domain == null ? JJKDamageSources.jujutsuAttack(owner, this) : JJKDamageSources.indirectJujutsuAttack(domain, owner, this);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 200.0f;
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    private void perform(LivingEntity owner, LivingEntity target, @Nullable DomainExpansionEntity domain) {
        int i;
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.SLASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (i = 1; i <= 20; ++i) {
            cap.delayTickEvent(() -> {
                if (!target.m_21224_()) {
                    level2.m_8767_((ParticleOptions)((SimpleParticleType)JJKParticles.SLASH.get()), target.m_20185_(), target.m_20186_(), target.m_20189_(), 0, (double)target.m_19879_(), 0.0, 0.0, 1.0);
                    Vec3 center = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
                    Vec3 offset = center.m_82520_((HelperMethods.RANDOM.m_188500_() - 0.5) * (double)target.m_20205_(), (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)target.m_20206_(), (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)target.m_20205_());
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                }
            }, i);
        }
        for (i = 1; i <= 10; ++i) {
            cap.delayTickEvent(() -> {
                if (!target.m_21224_()) {
                    owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.SLASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }, i * 2);
        }
        cap.delayTickEvent(() -> {
            boolean success;
            DamageSource source = this.getSource(owner, domain);
            float addeddmg = target.m_21233_() * 0.05f;
            float realdamage = this.getPower(owner) * 30.0f + addeddmg;
            if (domain != null) {
                float size = cap.getDomainSize();
                realdamage *= ((Double)ConfigHolder.SERVER.maximumDomainSize.get()).floatValue() + 0.1f - size;
            }
            if (!(success = target.m_6469_(source, realdamage)) || !(target instanceof Mob) && !(target instanceof Player)) {
                return;
            }
            owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.CLEAVE.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }, 25);
    }

    @Override
    public void performEntity(LivingEntity owner, LivingEntity target, DomainExpansionEntity domain) {
        this.perform(owner, target, domain);
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        this.perform(owner, target, null);
        return true;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }
}

