/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.block.entity.DomainBlockEntity;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;

public class DomainSkyBlockEntity
extends DomainBlockEntity {
    @Nullable
    private ResourceLocation domain;

    public DomainSkyBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JJKBlockEntities.DOMAIN_SKY.get(), pPos, pBlockState);
    }

    public void setDomain(@Nullable ResourceLocation domain) {
        this.domain = domain;
        this.markUpdated();
    }

    @Nullable
    public ResourceLocation getDomain() {
        return this.domain;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DomainSkyBlockEntity pBlockEntity) {
        if (pBlockEntity.domain == null) {
            Entity entity = ((ServerLevel)pLevel).m_8791_(pBlockEntity.identifier);
            if (!(entity instanceof DomainExpansionEntity)) {
                return;
            }
            DomainExpansionEntity domain = (DomainExpansionEntity)entity;
            pBlockEntity.setDomain(JJKAbilities.getKey(domain.getAbility()));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.domain != null) {
            pTag.m_128359_("domain", this.domain.toString());
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("domain")) {
            this.domain = new ResourceLocation(pTag.m_128461_("domain"));
        }
        if (this.f_58857_ != null) {
            this.markUpdated();
        }
    }
}

