/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.AbilityDisplayInfo;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.tab.AbilityTab;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.UnlockAbilityC2SPacket;

public class AbilityWidget {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final AbilityTab tab;
    private final Ability ability;
    private final AbilityDisplayInfo display;
    private final FormattedCharSequence title;
    private final int width;
    private final List<FormattedCharSequence> description;
    private final Minecraft minecraft;
    @Nullable
    private AbilityWidget parent;
    private final List<AbilityWidget> children = Lists.newArrayList();
    private final int x;
    private final int y;
    private boolean unlocked;
    private boolean unlockable;
    private boolean blocked;

    public AbilityWidget(AbilityTab tab, Minecraft minecraft, Ability ability) {
        this.tab = tab;
        this.ability = ability;
        this.display = ability.getDisplay((LivingEntity)minecraft.f_91074_);
        this.minecraft = minecraft;
        this.title = Language.m_128107_().m_5536_(minecraft.f_91062_.m_92854_((FormattedText)ability.getName(), 255));
        this.x = Mth.m_14143_((float)(this.display.getX() * 28.0f));
        this.y = Mth.m_14143_((float)(this.display.getY() * 27.0f));
        int l = 29 + minecraft.f_91062_.m_92724_(this.title);
        int cost = this.minecraft.f_91074_ == null ? 0 : this.ability.getRealPointsCost((LivingEntity)this.minecraft.f_91074_);
        MutableComponent component = Component.m_237119_();
        if (cost > 0) {
            component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.ability.cost", "jujutsu_kaisen"), (Object[])new Object[]{cost}));
        } else {
            component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.ability.locked", "jujutsu_kaisen"), (Object[])new Object[]{cost}));
        }
        this.description = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)component.m_6881_(), (Style)Style.f_131099_), l));
        for (FormattedCharSequence sequence : this.description) {
            l = Math.max(l, minecraft.f_91062_.m_92724_(sequence));
        }
        this.width = l + 3 + 5;
        this.update();
    }

    public void update() {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        this.unlockable = this.ability.canUnlock((LivingEntity)this.minecraft.f_91074_);
        this.unlocked = this.ability.isUnlocked((LivingEntity)this.minecraft.f_91074_);
        this.blocked = this.ability.isBlocked((LivingEntity)this.minecraft.f_91074_);
        for (AbilityWidget widget : this.children) {
            widget.update();
        }
    }

    private static float getMaxWidth(StringSplitter pManager, List<FormattedText> pText) {
        return (float)pText.stream().mapToDouble(arg_0 -> ((StringSplitter)pManager).m_92384_(arg_0)).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component pComponent, int pMaxWidth) {
        StringSplitter splitter = this.minecraft.f_91062_.m_92865_();
        List result = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List lines = splitter.m_92414_((FormattedText)pComponent, pMaxWidth - i, Style.f_131099_);
            float f1 = Math.abs(AbilityWidget.getMaxWidth(splitter, lines) - (float)pMaxWidth);
            if (f1 <= 10.0f) {
                return lines;
            }
            if (!(f1 < f)) continue;
            f = f1;
            result = lines;
        }
        return result;
    }

    @Nullable
    private AbilityWidget getFirstVisibleParent(Ability ability) {
        return this.tab.getAbility(ability.getParent((LivingEntity)this.minecraft.f_91074_));
    }

    public void drawConnectivity(GuiGraphics pGuiGraphics, int pX, int pY, boolean pDropShadow) {
        if (this.parent != null) {
            int i = pX + this.parent.x + 13;
            int j = pX + this.parent.x + 26 + 4;
            int k = pY + this.parent.y + 13;
            int l = pX + this.x + 13;
            int i1 = pY + this.y + 13;
            int color = pDropShadow ? (this.unlocked ? -16755964 : (this.unlockable ? -13948117 : (this.blocked ? -9830400 : -16777216))) : (this.unlocked ? -16742639 : (this.unlockable ? -10066330 : (this.blocked ? -3211264 : -1)));
            if (pDropShadow) {
                pGuiGraphics.m_280656_(j, i, k - 1, color);
                pGuiGraphics.m_280656_(j + 1, i, k, color);
                pGuiGraphics.m_280656_(j, i, k + 1, color);
                pGuiGraphics.m_280656_(l, j - 1, i1 - 1, color);
                pGuiGraphics.m_280656_(l, j - 1, i1, color);
                pGuiGraphics.m_280656_(l, j - 1, i1 + 1, color);
                pGuiGraphics.m_280315_(j - 1, i1, k, color);
                pGuiGraphics.m_280315_(j + 1, i1, k, color);
            } else {
                pGuiGraphics.m_280656_(j, i, k, color);
                pGuiGraphics.m_280656_(l, j, i1, color);
                pGuiGraphics.m_280315_(j, i1, k, color);
            }
        }
        for (AbilityWidget widget : this.children) {
            widget.drawConnectivity(pGuiGraphics, pX, pY, pDropShadow);
        }
    }

    public void draw(GuiGraphics pGuiGraphics, int pX, int pY) {
        pGuiGraphics.m_280218_(WIDGETS_LOCATION, pX + this.x + 3, pY + this.y, 0, this.unlocked ? 128 : 154, 26, 26);
        if (this.ability.isCursedEnergyColor() && this.minecraft.f_91074_ != null) {
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            Vector3f color = Vec3.m_82501_((int)cap.getCursedEnergyColor()).m_252839_();
            RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)1.0f);
        }
        pGuiGraphics.m_280163_(this.display.getIcon(), pX + this.x + 8, pY + this.y + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (AbilityWidget widget : this.children) {
            widget.draw(pGuiGraphics, pX, pY);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void addChild(AbilityWidget widget) {
        this.children.add(widget);
    }

    public void unlock() {
        ISorcererData cap;
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        if (this.unlockable && !this.unlocked && (cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElse(null)) != null && (cap.getPoints() - this.ability.getRealPointsCost((LivingEntity)this.minecraft.f_91074_) >= 0 || this.minecraft.f_91074_.m_150110_().f_35937_)) {
            this.minecraft.f_91074_.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f);
            PacketHandler.sendToServer(new UnlockAbilityC2SPacket(JJKAbilities.getKey(this.ability)));
            if (!this.minecraft.f_91074_.m_150110_().f_35937_) {
                cap.usePoints(this.ability.getRealPointsCost((LivingEntity)this.minecraft.f_91074_));
            }
            cap.unlock(this.ability);
            this.update();
        }
    }

    public void drawHover(GuiGraphics pGuiGraphics, int pX, int pY, float pFade, int pWidth, int pHeight) {
        boolean flag = pWidth + pX + this.x + this.width + 26 >= this.tab.getScreen().f_96543_;
        boolean flag1 = 113 - pY - this.y - 26 <= 6 + this.description.size() * 9;
        int i = this.width / 2;
        int j = this.width - i;
        RenderSystem.enableBlend();
        int l = pY + this.y;
        int k = flag ? pX + this.x - this.width + 26 + 6 : pX + this.x;
        int i1 = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (flag1) {
                pGuiGraphics.m_280260_(WIDGETS_LOCATION, k, l + 26 - i1, this.width, i1, 10, 200, 26, 0, 52);
            } else {
                pGuiGraphics.m_280260_(WIDGETS_LOCATION, k, l, this.width, i1, 10, 200, 26, 0, 52);
            }
        }
        pGuiGraphics.m_280218_(WIDGETS_LOCATION, k, l, 0, this.unlocked ? 0 : 26, i, 26);
        pGuiGraphics.m_280218_(WIDGETS_LOCATION, k + i, l, 200 - j, this.unlocked ? 0 : 26, j, 26);
        pGuiGraphics.m_280218_(WIDGETS_LOCATION, pX + this.x + 3, pY + this.y, 0, this.unlocked ? 128 : 154, 26, 26);
        if (flag) {
            pGuiGraphics.m_280648_(this.minecraft.f_91062_, this.title, k + 5, pY + this.y + 9, -1);
        } else {
            pGuiGraphics.m_280648_(this.minecraft.f_91062_, this.title, pX + this.x + 32, pY + this.y + 9, -1);
        }
        if (flag1) {
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                pGuiGraphics.m_280649_(this.minecraft.f_91062_, this.description.get(k1), k + 5, l + 26 - i1 + 7 + k1 * 9, -5592406, false);
            }
        } else {
            for (int l1 = 0; l1 < this.description.size(); ++l1) {
                pGuiGraphics.m_280649_(this.minecraft.f_91062_, this.description.get(l1), k + 5, pY + this.y + 9 + 17 + l1 * 9, -5592406, false);
            }
        }
        if (this.ability.isCursedEnergyColor() && this.minecraft.f_91074_ != null) {
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            Vector3f color = Vec3.m_82501_((int)cap.getCursedEnergyColor()).m_252839_();
            RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)1.0f);
        }
        pGuiGraphics.m_280163_(this.display.getIcon(), pX + this.x + 8, pY + this.y + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isMouseOver(int pX, int pY, int pMouseX, int pMouseY) {
        int i = pX + this.x;
        int j = i + 26;
        int k = pY + this.y;
        int l = k + 26;
        return pMouseX >= i && pMouseX <= j && pMouseY >= k && pMouseY <= l;
    }

    public void attachToParent() {
        if (this.parent == null && this.ability.getParent((LivingEntity)this.minecraft.f_91074_) != null) {
            this.parent = this.getFirstVisibleParent(this.ability);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

