/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.render.entity.effect.BoltEffect;
import radon.jujutsu_kaisen.client.render.entity.effect.BoltRenderer;
import radon.jujutsu_kaisen.entity.effect.LightningEntity;

public class LightningRenderer
extends EntityRenderer<LightningEntity> {
    private final BoltRenderer renderer = new BoltRenderer();

    public LightningRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(@NotNull LightningEntity pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Entity entity = pEntity.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vector3f color = ParticleColors.getCursedEnergyColor((Entity)owner);
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.0f, pEntity.m_20206_() / 2.0f, 0.0f);
        double collidePosX = pEntity.collidePosX;
        double collidePosY = pEntity.collidePosY;
        double collidePosZ = pEntity.collidePosZ;
        Vec3 start = new Vec3(pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_());
        Vec3 end = new Vec3(collidePosX, collidePosY, collidePosZ);
        BoltEffect.BoltRenderInfo info = new BoltEffect.BoltRenderInfo(1.0f, 0.1f, 0.1f, 0.1f, new Vector4f(color.x, color.y, color.z, 0.8f), 1.4f);
        BoltEffect bolt = new BoltEffect(info, start, end, (int)Math.sqrt(start.m_82554_(end)) * 10).size(0.05f).lifespan(1).fade(BoltEffect.FadeFunction.NONE).spawn(BoltEffect.SpawnFunction.CONSECUTIVE);
        this.renderer.update(null, bolt, pPartialTick);
        pPoseStack.m_85837_(-pEntity.m_20185_(), -pEntity.m_20186_(), -pEntity.m_20189_());
        this.renderer.render(pPartialTick, pPoseStack, pBuffer);
        pPoseStack.m_85849_();
    }

    protected int getBlockLightLevel(@NotNull LightningEntity pEntity, @NotNull BlockPos pPos) {
        return 15;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull LightningEntity pEntity) {
        return TextureAtlas.f_118259_;
    }
}

