/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.particle.TravelParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class MeteorEntity
extends JujutsuProjectile {
    private static final EntityDataAccessor<Integer> DATA_EXPLOSION_TIME = SynchedEntityData.m_135353_(MeteorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int SIZE = 5;
    public static final int HEIGHT = 20;
    private static final int MAX_SIZE = 25;
    public static final int DELAY = 80;
    private static final double SPEED = 2.0;
    private static final int DURATION = 100;
    private static final float DAMAGE = 18.0f;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public MeteorEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public MeteorEntity(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.METEOR.get()), owner.m_9236_(), (Entity)owner, power);
        owner.m_146884_(owner.m_20182_().m_82520_(0.0, (double)(20 + MeteorEntity.getSize(power)), 0.0));
        this.applyOffset();
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EXPLOSION_TIME, (Object)0);
    }

    @Override
    public boolean m_6783_(double pDistance) {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return this.m_20206_() * 1.5f;
    }

    @Override
    public boolean canDeflect() {
        return false;
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setExplosionTime(pCompound.m_128451_("explosion_time"));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("explosion_time", this.getExplosionTime());
    }

    private float getFrictionInfluencedSpeed(float pFriction) {
        return this.m_20096_() ? 0.7f * (0.21600002f / (pFriction * pFriction * pFriction)) : 0.02f;
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 pDeltaMovement, float pFriction) {
        this.m_19920_(this.getFrictionInfluencedSpeed(pFriction), pDeltaMovement);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        return this.m_20184_();
    }

    private void doPush(Entity entity) {
        entity.m_7334_((Entity)this);
    }

    private void pushEntities() {
        AABB bounds = AABB.m_165882_((Vec3)this.m_20182_(), (double)(this.getSize() * 2), (double)(this.getSize() * 2), (double)(this.getSize() * 2));
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), bounds, EntitySelector.m_20421_((Entity)this)).forEach(this::doPush);
        } else {
            List entities = this.m_9236_().m_6249_((Entity)this, bounds, EntitySelector.m_20421_((Entity)this));
            if (!entities.isEmpty()) {
                int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
                if (i > 0 && entities.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                    int j = 0;
                    for (Entity entity : entities) {
                        if (entity.m_20159_()) continue;
                        ++j;
                    }
                    if (j > i - 1) {
                        this.m_6469_(this.m_269291_().m_269354_(), 4.0f);
                    }
                }
                for (Entity entity : entities) {
                    this.doPush(entity);
                }
            }
        }
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.lerpX = pX;
        this.lerpY = pY;
        this.lerpZ = pZ;
        this.lerpYRot = pYaw;
        this.lerpXRot = pPitch;
        this.lerpSteps = pPosRotationIncrements;
    }

    public void travel() {
        if (this.m_6109_()) {
            double d0 = 0.08;
            BlockPos pos = this.m_20099_();
            float f2 = this.m_9236_().m_8055_(this.m_20099_()).getFriction((LevelReader)this.m_9236_(), this.m_20099_(), (Entity)this);
            float f3 = this.m_20096_() ? f2 * 0.91f : 0.91f;
            Vec3 vec35 = this.handleRelativeFrictionAndCalculateMovement(Vec3.f_82478_, f2);
            double d2 = vec35.f_82480_;
            if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(pos)) {
                d2 = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
            } else if (!this.m_20068_()) {
                d2 -= d0;
            }
            this.m_20334_(vec35.f_82479_ * (double)f3, d2 * (double)0.98f, vec35.f_82481_ * (double)f3);
        }
    }

    public void aiStep() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d2 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d4 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d6 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (!this.m_21515_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        Vec3 vec31 = this.m_20184_();
        double d1 = vec31.f_82479_;
        double d3 = vec31.f_82480_;
        double d5 = vec31.f_82481_;
        if (Math.abs(vec31.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec31.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec31.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.travel();
        this.pushEntities();
    }

    public static int getSize(float power) {
        return Math.min(25, Math.round(5.0f * power));
    }

    public int getSize() {
        return Math.round((float)MeteorEntity.getSize(this.getPower()) * ((float)Math.min(80, this.getTime()) / 80.0f));
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        int size = this.getSize();
        return EntityDimensions.m_20398_((float)size, (float)size);
    }

    private void hurtEntities() {
        double radius = this.getSize();
        AABB bounds = this.m_20191_().m_82400_(radius * 1.5);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (Entity entity2 : this.m_9236_().m_45933_((Entity)owner, bounds)) {
                if (Math.sqrt(entity2.m_20275_(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_())) >= (double)this.getSize() || !entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.MAXIMUM_METEOR.get()), 18.0f * this.getPower())) continue;
                entity2.m_20254_(10);
            }
        }
    }

    @Override
    protected boolean isProjectile() {
        return false;
    }

    private void spawnParticles() {
        Vec3 center = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        float radius = (float)this.getSize() * 1.1f;
        int count = (int)((double)radius * Math.PI * 2.0) / 2;
        for (int i = 0; i < count; ++i) {
            double theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double phi = this.f_19796_.m_188500_() * Math.PI;
            double xOffset = (double)radius * Math.sin(phi) * Math.cos(theta);
            double yOffset = (double)radius * Math.sin(phi) * Math.sin(theta);
            double zOffset = (double)radius * Math.cos(phi);
            double x = center.f_82479_ + xOffset;
            double y = center.f_82480_ + yOffset;
            double z = center.f_82481_ + zOffset;
            this.m_9236_().m_6493_((ParticleOptions)new TravelParticle.TravelParticleOptions(center.m_252839_(), ParticleColors.FIRE_ORANGE, radius * 0.4f, 0.25f, true, 20), true, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void evaporateWater() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        float radius = this.getSize();
        AABB bounds = AABB.m_165882_((Vec3)this.m_20182_(), (double)(radius * 2.0f), (double)(radius * 2.0f), (double)(radius * 2.0f));
        double centerX = bounds.m_82399_().f_82479_;
        double centerY = bounds.m_82399_().f_82480_;
        double centerZ = bounds.m_82399_().f_82481_;
        int x = (int)bounds.f_82288_;
        while ((double)x <= bounds.f_82291_) {
            int y = (int)bounds.f_82289_;
            while ((double)y <= bounds.f_82292_) {
                int z = (int)bounds.f_82290_;
                while ((double)z <= bounds.f_82293_) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                    if (!(distance > (double)radius) && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos) && !state.m_60819_().m_76178_()) {
                        owner.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
                        this.m_9236_().m_46796_(1501, pos, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void breakBlocks() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        float radius = this.getSize();
        AABB bounds = AABB.m_165882_((Vec3)this.m_20182_(), (double)(radius * 2.0f), (double)(radius * 2.0f), (double)(radius * 2.0f));
        double centerX = bounds.m_82399_().f_82479_;
        double centerY = bounds.m_82399_().f_82480_;
        double centerZ = bounds.m_82399_().f_82481_;
        int x = (int)bounds.f_82288_;
        while ((double)x <= bounds.f_82291_) {
            int y = (int)bounds.f_82289_;
            while ((double)y <= bounds.f_82292_) {
                int z = (int)bounds.f_82290_;
                while ((double)z <= bounds.f_82293_) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                    if (!(distance > (double)radius) && HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, pos) && state.m_60819_().m_76178_()) {
                        this.m_9236_().m_46961_(pos, false);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public int getExplosionTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_EXPLOSION_TIME);
    }

    private void setExplosionTime(int time) {
        this.f_19804_.m_135381_(DATA_EXPLOSION_TIME, (Object)time);
    }

    private void applyOffset() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle(owner);
        this.m_146884_(owner.m_20182_().m_82546_(look.m_82542_((double)(this.m_20205_() * 2.0f), (double)(this.getSize() * 2), (double)(this.m_20205_() * 2.0f))));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        if (this.getExplosionTime() == 0 && this.getTime() - 80 >= 100) {
            this.m_146870_();
            return;
        }
        this.spawnParticles();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.getTime() >= 80 && this.getExplosionTime() == 0) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
            } else {
                this.aiStep();
            }
            if (this.getTime() < 80) {
                Vec3 movement = owner.m_20184_();
                if (movement.f_82480_ < 0.0) {
                    owner.m_20334_(movement.f_82479_, 0.0, movement.f_82481_);
                    owner.m_19920_(0.04f, new Vec3((double)owner.f_20900_, 0.0, (double)owner.f_20902_));
                }
                if (!this.m_9236_().f_46443_) {
                    this.applyOffset();
                }
            } else if (!this.m_9236_().f_46443_) {
                this.hurtEntities();
                if (this.getTime() == 80) {
                    this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(2.0));
                }
                int duration = this.getSize() * 5;
                int time = this.getExplosionTime();
                if (time > 0) {
                    if (time >= duration) {
                        this.m_146870_();
                    } else {
                        this.setExplosionTime(++time);
                    }
                } else {
                    Vec3 start = this.m_20182_();
                    Vec3 end = start.m_82549_(this.m_20184_().m_82490_((double)this.getSize() / 2.0));
                    BlockHitResult clip = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
                    if (!this.m_9236_().m_8055_(clip.m_82425_()).m_60795_()) {
                        this.setExplosionTime(1);
                        ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), clip.m_82450_(), (float)this.getSize() * 1.5f, duration, this.getPower() * 0.5f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.MAXIMUM_METEOR.get()), true);
                    }
                    this.breakBlocks();
                }
                this.evaporateWater();
            }
        }
    }
}

