/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScissorEntity
extends JujutsuProjectile
implements GeoEntity {
    private static final float DAMAGE = 20.0f;
    private static final int CUT_DURATION = 5;
    private static final int DELAY = 20;
    private static final double SPEED = 2.5;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CUT = RawAnimation.begin().thenPlay("misc.cut");
    private LivingEntity target;

    public ScissorEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public ScissorEntity(LivingEntity owner, float power, LivingEntity target) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.SCISSOR.get()), owner.m_9236_(), (Entity)owner, power);
        this.target = target;
        double offsetX = this.f_19796_.m_188500_() * 4.0 - 2.0;
        double offsetZ = this.f_19796_.m_188500_() * 4.0 - 2.0;
        this.m_146884_(target.m_20182_().m_82520_(offsetX, (double)(target.m_20206_() * 1.5f), offsetZ));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    private PlayState cutPredicate(AnimationState<ScissorEntity> animationState) {
        if (this.getTime() - 5 > 0) {
            return animationState.setAndContinue(CUT);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Cut", this::cutPredicate)});
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            pResult.m_82443_().m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.SCISSORS.get()), 20.0f * this.getPower());
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.target == null || this.target.m_213877_() || !this.target.m_6084_()) {
            this.m_146870_();
            return;
        }
        Vec3 direction = this.target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double pitch = Math.asin(direction.f_82480_);
        double yaw = Math.atan2(direction.f_82479_, direction.f_82481_);
        this.m_19915_((float)Math.toDegrees(yaw), (float)Math.toDegrees(pitch));
        if (this.getTime() == 20) {
            this.m_20256_(this.target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(2.5));
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

