/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.block.VeilBlock;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.SlicedEntityParticle;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.ParticleUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class DismantleProjectile
extends JujutsuProjectile {
    private static final EntityDataAccessor<Float> DATE_ROLL = SynchedEntityData.m_135353_(DismantleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_LENGTH = SynchedEntityData.m_135353_(DismantleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int DURATION = 10;
    private static final int LINE_LENGTH = 2;
    public static final int MIN_LENGTH = 3;
    public static final int MAX_LENGTH = 12;
    private boolean canHurt = true;
    private boolean instant;
    private boolean destroy = true;
    private int destroyed;

    public DismantleProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public DismantleProjectile(LivingEntity owner, float power, float roll) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.DISMANTLE.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
        this.setRoll(roll);
    }

    public DismantleProjectile(LivingEntity owner, float power, float roll, Vec3 pos, int length) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.DISMANTLE.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, pos.m_82492_(0.0, (double)(this.m_20206_() / 2.0f), 0.0));
        this.setRoll(roll);
        this.setLength(length);
    }

    public DismantleProjectile(LivingEntity owner, float power, float roll, Vec3 pos, int length, boolean instant, boolean destroy) {
        this(owner, power, roll, pos, length);
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (this.f_19796_.m_188501_() - 0.5f) * 360.0f, 0.0f);
        this.instant = instant;
        this.destroy = destroy;
    }

    public void setDuration(int tim) {
        this.DURATION = tim;
    }

    public void setCanHurt(boolean bool) {
        this.canHurt = bool;
    }

    protected float getDamage() {
        return 15.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATE_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_LENGTH, (Object)0);
    }

    public int getLength() {
        int length = (Integer)this.f_19804_.m_135370_(DATA_LENGTH);
        return length > 0 ? length : Math.max(3, Math.min(12, Mth.m_14143_((float)(2.0f * this.getPower()))));
    }

    private void setLength(int length) {
        this.f_19804_.m_135381_(DATA_LENGTH, (Object)length);
    }

    public float getRoll() {
        return ((Float)this.f_19804_.m_135370_(DATE_ROLL)).floatValue();
    }

    private void setRoll(float roll) {
        this.f_19804_.m_135381_(DATE_ROLL, (Object)Float.valueOf(roll));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("roll", this.getRoll());
        pCompound.m_128405_("length", this.getLength());
        pCompound.m_128379_("instant", this.instant);
        pCompound.m_128379_("destroy", this.destroy);
        pCompound.m_128405_("destroyed", this.destroyed);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATE_ROLL, (Object)Float.valueOf(pCompound.m_128457_("roll")));
        this.f_19804_.m_135381_(DATA_LENGTH, (Object)pCompound.m_128451_("length"));
        this.instant = pCompound.m_128471_("instant");
        this.destroy = pCompound.m_128471_("destroy");
        this.destroyed = pCompound.m_128451_("destroyed");
    }

    protected void m_6763_(@NotNull BlockState pState) {
        if (pState.m_60734_().m_155943_() <= -1.0f) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        LivingEntity owner;
        Entity entity;
        block9: {
            block8: {
                super.m_5790_(pResult);
                if (this.m_9236_().f_46443_) {
                    return;
                }
                entity = pResult.m_82443_();
                Entity entity2 = this.m_19749_();
                if (!(entity2 instanceof LivingEntity)) break block8;
                owner = (LivingEntity)entity2;
                if (entity instanceof LivingEntity) break block9;
            }
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (owner == entity && !cap.hasSelfHit()) {
            return;
        }
        if (!this.canHurt) {
            return;
        }
        DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
        if (entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)(domain == null ? this : domain), owner, (Ability)JJKAbilities.DISMANTLE.get()), this.getDamage() * this.getPower())) {
            if (!((Boolean)ConfigHolder.SERVER.entitySlicing.get()).booleanValue() || !living.m_21224_()) {
                return;
            }
            Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
            float yaw = this.m_146908_();
            float pitch = this.m_146909_();
            float roll = this.getRoll();
            Vec3 forward = this.m_20171_(pitch, yaw);
            Vec3 up = this.m_20171_(pitch - 90.0f, yaw);
            Quaternionf quaternion = new Quaternionf().rotateAxis((float)Math.toRadians(-roll), (float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
            Vec3 side = new Vec3(quaternion.transform(forward.m_82537_(up).m_252839_()));
            int length = this.getLength();
            Vec3 start = side.m_82490_((double)length / 2.0);
            Vec3 end = forward.m_82546_(start);
            Vec3 plane = end.m_82537_(start).m_82541_();
            float distance = (float)plane.m_82526_(center.m_82546_(living.m_20182_()));
            ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new SlicedEntityParticle.SliceParticleOptions(living.m_19879_(), plane.m_252839_(), distance), true, living.m_20185_(), living.m_20186_(), living.m_20189_(), 0.0, 0.0, 0.0);
            living.m_6842_(true);
            living.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 60, 0, false, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60, 0, false, false, false));
        }
    }

    private Vec3 rotate(Vec3 vector, Vec3 axis, double degrees) {
        double radians = degrees * Math.PI / 180.0;
        double cosine = Math.cos(radians);
        double sine = Math.sin(radians);
        double xx = (1.0 - cosine) * axis.f_82479_ * axis.f_82479_;
        double xy = (1.0 - cosine) * axis.f_82479_ * axis.f_82480_;
        double xz = (1.0 - cosine) * axis.f_82479_ * axis.f_82481_;
        double yy = (1.0 - cosine) * axis.f_82480_ * axis.f_82480_;
        double yz = (1.0 - cosine) * axis.f_82480_ * axis.f_82481_;
        double zz = (1.0 - cosine) * axis.f_82481_ * axis.f_82481_;
        return new Vec3((cosine + xx) * vector.f_82479_ + (xy - axis.f_82481_ * sine) * vector.f_82480_ + (xz + axis.f_82480_ * sine) * vector.f_82481_, (xy + axis.f_82481_ * sine) * vector.f_82479_ + (cosine + yy) * vector.f_82480_ + (yz - axis.f_82479_ * sine) * vector.f_82481_, (xz - axis.f_82480_ * sine) * vector.f_82479_ + (yz + axis.f_82479_ * sine) * vector.f_82480_ + (cosine + zz) * vector.f_82481_);
    }

    public List<HitResult> getHitResults() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return List.of();
        }
        LivingEntity owner = (LivingEntity)entity;
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        float yaw = this.m_146908_();
        float pitch = this.m_146909_();
        float roll = this.getRoll();
        Vec3 forward = this.m_20171_(pitch, 180.0f - yaw);
        Vec3 up = this.m_20171_(pitch - 90.0f, 180.0f - yaw);
        Vec3 side = this.rotate(forward.m_82537_(up), forward, -roll);
        int length = this.getLength();
        Vec3 start = center.m_82549_(side.m_82490_((double)length / 2.0));
        Vec3 end = center.m_82549_(forward.m_82546_(side.m_82490_((double)length / 2.0)));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        double depth = Math.max(1L, Math.round(this.m_20184_().m_82553_()));
        int z = 0;
        while ((double)z < depth) {
            for (int x = 0; x < length; ++x) {
                boolean destroyed;
                BlockPos current = BlockPos.m_274446_((Position)start.m_82549_(end.m_82546_(start).m_82490_(1.0 / (double)length * (double)x).m_82549_(forward.m_82490_((double)z))));
                AABB bounds = AABB.m_165882_((Vec3)current.m_252807_(), (double)0.5, (double)0.5, (double)0.5);
                for (Entity entity2 : this.m_9236_().m_45933_((Entity)this, bounds)) {
                    hits.add((HitResult)new EntityHitResult(entity2));
                }
                if (!this.destroy || !this.canHurt) continue;
                BlockState state = this.m_9236_().m_8055_(current);
                if (state.m_60734_() instanceof VeilBlock) {
                    this.m_146870_();
                    this.destroyed += 15;
                    return hits;
                }
                if (this.isDomain() || !HelperMethods.isDestroyable((BlockGetter)this.m_9236_(), owner, current) || !(destroyed = state.m_60819_().m_76178_() ? owner.m_9236_().m_7731_(current, Blocks.f_50016_.m_49966_(), 18) : this.m_9236_().m_46597_(current, Blocks.f_50016_.m_49966_()))) continue;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, current.m_252807_().f_82479_, current.m_252807_().f_82480_, current.m_252807_().f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                ++this.destroyed;
            }
            ++z;
        }
        return hits;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            for (HitResult result : this.getHitResults()) {
                if (result.m_6662_() == HitResult.Type.MISS) continue;
                this.m_6532_(result);
            }
            if (this.instant || this.destroyed >= this.getLength() * 2 || this.getTime() >= this.DURATION) {
                this.m_146870_();
            }
        }
    }
}

