/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.HollowPurpleExplosion;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.BlueProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class RedProjectile
extends JujutsuProjectile {
    private static final double LAUNCH_POWER = 10.0;
    private static final float EXPLOSIVE_POWER = 5.0f;
    private static final float MAX_EXPLOSION = 17.0f;
    public static final int DELAY = 15;
    private static final int DURATION = 60;
    private static final float SPEED = 5.0f;
    private static final float DAMAGE = 26.0f;
    private boolean chanted;

    public RedProjectile(EntityType<? extends Projectile> pType, Level level) {
        super(pType, level);
    }

    public RedProjectile(LivingEntity owner, float power, boolean chanted) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.RED.get()), owner.m_9236_(), (Entity)owner, power);
        this.chanted = chanted;
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("chanted", this.chanted);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.chanted = pCompound.m_128471_("chanted");
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (entity == owner && !cap.hasSelfHit()) {
            return;
        }
        float factor = 1.0f - ((float)this.getTime() - 15.0f) / 60.0f;
        if (entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.RED.get()), 26.0f * factor * this.getPower())) {
            entity.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)this).m_82542_(1.0, 0.25, 1.0).m_82490_(10.0));
            entity.f_19864_ = true;
        }
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        super.m_6532_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (pResult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)pResult).m_82443_() == owner && !cap.hasSelfHit()) {
            return;
        }
        this.m_5496_((SoundEvent)JJKSounds.RED_EXPLOSION.get(), 3.0f, 1.0f);
        float radius = Math.min(17.0f, 5.0f * this.getPower());
        Vec3 offset = new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), offset, radius, 20, this.getPower() * 0.33f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.RED.get()), false, false);
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        block9: {
            LivingEntity owner;
            block12: {
                block11: {
                    block10: {
                        super.m_8119_();
                        Entity entity = this.m_19749_();
                        if (!(entity instanceof LivingEntity)) break block9;
                        owner = (LivingEntity)entity;
                        if (this.getTime() >= 15) break block10;
                        if (!owner.m_6084_()) {
                            this.m_146870_();
                        } else {
                            if (this.getTime() % 5 == 0) {
                                owner.m_6674_(InteractionHand.MAIN_HAND);
                            }
                            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                            EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
                        }
                        break block9;
                    }
                    if (this.getTime() < 60) break block11;
                    this.m_146870_();
                    break block9;
                }
                if (this.getTime() < 15) break block9;
                if (this.m_9236_().f_46443_ || !this.chanted) break block12;
                ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                for (BlueProjectile blue : this.m_9236_().m_45976_(BlueProjectile.class, this.m_20191_().m_82369_(this.m_20184_()))) {
                    Player player;
                    block14: {
                        block13: {
                            if (!(owner instanceof Player)) break block13;
                            player = (Player)owner;
                            if (player.m_150110_().f_35937_) break block14;
                        }
                        if (((Ability)JJKAbilities.HOLLOW_PURPLE.get()).getStatus(owner) != Ability.Status.SUCCESS) continue;
                    }
                    if (owner instanceof ServerPlayer) {
                        player = (ServerPlayer)owner;
                        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), (ServerPlayer)player);
                    }
                    HollowPurpleExplosion explosion = new HollowPurpleExplosion(owner, this.getPower(), blue.m_20182_().m_82520_(0.0, (double)(blue.m_20206_() / 2.0f), 0.0));
                    this.m_9236_().m_7967_((Entity)explosion);
                    blue.m_146870_();
                    this.m_146870_();
                    break;
                }
            }
            if (this.getTime() == 15) {
                this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(5.0));
            }
        }
    }
}

