/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PiercingBullEntity
extends TenShadowsSummon {
    private static final float DAMAGE = 17.0f;
    private static final int INTERVAL = 200;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");

    public PiercingBullEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public PiercingBullEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.PIERCING_BULL.get()), owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return false;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    protected void m_8024_() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
            if ((this.m_20096_() || this.isInFluidType()) && (this.m_20142_() || this.getTime() % 200 == 0)) {
                this.m_6858_(true);
                this.m_6478_(MoverType.SELF, target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.m_20270_((Entity)target)));
                float distance = this.m_20270_((Entity)target);
                ISorcererData cap = (ISorcererData)this.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                for (Entity entity : this.m_9236_().m_45933_((Entity)this.m_269323_(), this.m_20191_().m_82400_(1.0))) {
                    if (entity == this || !entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 17.0f * distance * cap.getAbilityPower())) continue;
                    entity.m_20256_(this.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82548_().m_82490_((double)cap.getAbilityPower()));
                    entity.f_19864_ = true;
                    this.m_9236_().m_255391_((Entity)this, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), cap.getAbilityPower(), false, Level.ExplosionInteraction.NONE);
                    if (entity != target) continue;
                    this.m_6858_(false);
                }
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 17.5);
    }

    private PlayState walkRunIdlePredicate(AnimationState<PiercingBullEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState swingPredicate(AnimationState<PiercingBullEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.PIERCING_BULL.get();
    }

    public float getStepHeight() {
        return 2.0f;
    }
}

