/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.base.SummonEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncTenShadowsDataS2CPacket;

public abstract class TenShadowsSummon
extends SummonEntity
implements ICommandable,
ISorcerer {
    private static final int MAX_DISTANCE = 128;
    private static final double RITUAL_RANGE = 32.0;
    private static final EntityDataAccessor<Boolean> DATA_CLONE = SynchedEntityData.m_135353_(TenShadowsSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final List<UUID> participants = new ArrayList<UUID>();
    protected boolean ritualNullified = false;
    private int participantCheckCooldown = 0;

    protected TenShadowsSummon(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
        AttributeInstance attribute = this.m_21051_(Attributes.f_22277_);
        if (attribute != null) {
            attribute.m_22100_(128.0);
        }
    }

    protected abstract boolean isCustom();

    protected abstract boolean canFly();

    protected boolean shouldDespawn() {
        LivingEntity owner = this.m_269323_();
        if (owner != null) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!JJKAbilities.hasToggled(owner, this.getAbility()) || cap.getEnergy() <= 100.0f) {
                return true;
            }
        }
        return this.m_21224_();
    }

    private void createGoals() {
        int target = 1;
        int goal = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new FloatGoal((Mob)this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 25.0f, 10.0f, this.canFly()));
            this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        } else {
            this.f_21346_.m_25352_(target, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, entity -> this.participants.contains(entity.m_20148_())));
        }
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        TamableAnimal tamable;
        if (pTarget == this.m_269323_() && this.m_21824_()) {
            return false;
        }
        return !(!super.m_6779_(pTarget) || pTarget.m_6095_() == this.m_6095_() && !((TenShadowsSummon)pTarget).isClone() || pTarget instanceof TamableAnimal && (tamable = (TamableAnimal)pTarget).m_269323_() == this.m_269323_() && tamable.m_21824_() == this.m_21824_());
    }

    public void setClone(boolean clone) {
        this.f_19804_.m_135381_(DATA_CLONE, (Object)clone);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.m_6134_());
    }

    private void spawnParticles() {
        this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
        for (int i = 0; i < 16; ++i) {
            int j = 0;
            while ((float)j < this.m_20206_() * this.m_20206_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)this.m_20205_() * this.f_19796_.m_188583_() * (double)0.1f, this.m_20186_(), this.m_20189_() + (double)this.m_20205_() * this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * 0.075, this.f_19796_.m_188583_() * 0.25, this.f_19796_.m_188583_() * 0.075);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)this.m_20205_() * this.f_19796_.m_188583_() * (double)0.1f, this.m_20186_(), this.m_20189_() + (double)this.m_20205_() * this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * 0.075, this.f_19796_.m_188583_() * 0.25, this.f_19796_.m_188583_() * 0.075);
                ++j;
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLONE, (Object)false);
    }

    @Override
    public boolean canChangeTarget() {
        return this.m_21824_();
    }

    @Override
    public void changeTarget(LivingEntity target) {
        TenShadowsSummon sum;
        if (!(target instanceof TenShadowsSummon) || (sum = (TenShadowsSummon)target).m_21824_() && sum.m_5448_() == this.m_269323_()) {
            this.m_6710_(target);
        }
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.isCustom()) {
            this.createGoals();
        }
        this.spawnParticles();
        if (!this.m_21824_()) {
            Vec3 center = this.m_20182_();
            LivingEntity owner = this.m_269323_();
            this.addParticipants(center, owner);
        }
    }

    public boolean isClone() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CLONE);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.spawnParticles();
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.isClone()) {
            return;
        }
        LivingEntity owner = this.m_269323_();
        if (owner != null && !owner.m_9236_().f_46443_) {
            ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            if (!this.m_21824_()) {
                TamableAnimal tamable;
                Entity entity;
                if (pCause.m_7639_() == owner || (entity = pCause.m_7639_()) instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && tamable.m_269323_() == owner) {
                    cap.tame(this.m_9236_().m_9598_().m_175515_(Registries.f_256939_), this.m_6095_());
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        PacketHandler.sendToClient(new SyncTenShadowsDataS2CPacket(cap.serializeNBT()), player);
                    }
                }
            } else {
                Summon<?> ability = this.getAbility();
                if (ability.isTotality()) {
                    for (EntityType<?> fusion : ability.getFusions()) {
                        if (JJKAbilities.isDead(owner, fusion)) continue;
                        cap.kill(this.m_9236_().m_9598_().m_175515_(Registries.f_256939_), fusion);
                        if (!(owner instanceof ServerPlayer)) continue;
                        ServerPlayer player = (ServerPlayer)owner;
                        PacketHandler.sendToClient(new SyncTenShadowsDataS2CPacket(cap.serializeNBT()), player);
                    }
                } else if (ability.canDie()) {
                    cap.kill(this.m_9236_().m_9598_().m_175515_(Registries.f_256939_), this.m_6095_());
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        PacketHandler.sendToClient(new SyncTenShadowsDataS2CPacket(cap.serializeNBT()), player);
                    }
                }
            }
        }
    }

    private void addParticipants(Vec3 center, LivingEntity owner) {
        AABB area = new AABB(center.f_82479_ - 32.0, center.f_82480_ - 32.0, center.f_82481_ - 32.0, center.f_82479_ + 32.0, center.f_82480_ + 32.0, center.f_82481_ + 32.0);
        for (LivingEntity participant2 : this.m_9236_().m_6443_(LivingEntity.class, area, participant -> {
            TenShadowsSummon sum;
            return participant != this && (participant.m_6095_() != this.m_6095_() || !(participant instanceof TenShadowsSummon) || !(sum = (TenShadowsSummon)participant).isClone()) && participant.getCapability(SorcererDataHandler.INSTANCE).isPresent();
        })) {
            TamableAnimal tamable;
            if (!(participant2 == owner || participant2 instanceof TamableAnimal && (tamable = (TamableAnimal)participant2).m_269323_() == owner)) {
                this.ritualNullified = true;
            }
            this.participants.add(participant2.m_20148_());
        }
    }

    private void checkParticipants() {
        Iterator<UUID> iter = this.participants.iterator();
        while (iter.hasNext()) {
            UUID identifier = iter.next();
            LivingEntity participant = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(identifier);
            if (participant != null && !participant.m_213877_() && participant.m_6084_() && !(participant.m_20270_((Entity)this) > 128.0f)) continue;
            iter.remove();
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        LivingEntity livingAttacker;
        Entity attacker;
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && result && (attacker = source.m_7639_()) instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker) != this) {
            this.participants.add(livingAttacker.m_20148_());
        }
        return result;
    }

    @Override
    public void m_8119_() {
        LivingEntity owner = this.m_269323_();
        if (!this.m_21824_() && owner != null && !owner.m_213877_() && owner.m_6084_() && !this.shouldDespawn()) {
            Vec3 center = this.m_20182_();
            this.addParticipants(center, owner);
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && (owner == null || owner.m_213877_() || !owner.m_6084_() || this.shouldDespawn())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (!this.m_21824_()) {
                if (this.participantCheckCooldown-- <= 0) {
                    this.participantCheckCooldown = 20;
                    this.checkParticipants();
                    boolean disappear = this.participants.isEmpty();
                    if (disappear) {
                        this.m_146870_();
                    } else {
                        Vec3 center = this.m_20182_();
                        this.addParticipants(center, owner);
                    }
                }
            } else {
                LivingEntity target = this.m_5448_();
                this.m_21839_(target != null && !target.m_213877_() && target.m_6084_());
            }
            if (owner != null && this.isClone() && !JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.CHIMERA_SHADOW_GARDEN.get())) {
                this.m_146870_();
            }
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag participantsTag = new ListTag();
        for (UUID identifier : this.participants) {
            participantsTag.add((Object)NbtUtils.m_129226_((UUID)identifier));
        }
        pCompound.m_128365_("participants", (Tag)participantsTag);
        pCompound.m_128379_("clone", ((Boolean)this.f_19804_.m_135370_(DATA_CLONE)).booleanValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (Tag key : pCompound.m_128437_("participants", 11)) {
            this.participants.add(NbtUtils.m_129233_((Tag)key));
        }
        this.f_19804_.m_135381_(DATA_CLONE, (Object)pCompound.m_128471_("clone"));
    }

    public boolean m_21830_(@NotNull LivingEntity pEntity) {
        return this.m_21824_() && super.m_7306_((Entity)pEntity);
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SHIKIGAMI;
    }

    @Override
    public float getExperience() {
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return 0.0f;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getExperience() * 0.9f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }
}

