/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.CameraShakeS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.ParticleUtil;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExplosionHandler {
    private static final List<ExplosionData> explosions = new CopyOnWriteArrayList<ExplosionData>();

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> pDropPositionArray, ItemStack pStack, BlockPos pPos) {
        int i = pDropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)pDropPositionArray.get(j);
            ItemStack stack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)stack, (ItemStack)pStack)) continue;
            ItemStack merged = ItemEntity.m_32029_((ItemStack)stack, (ItemStack)pStack, (int)16);
            pDropPositionArray.set(j, (Object)Pair.of((Object)merged, (Object)((BlockPos)pair.getSecond())));
            if (!pStack.m_41619_()) continue;
            return;
        }
        pDropPositionArray.add((Object)Pair.of((Object)pStack, (Object)pPos));
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        ArrayList<ExplosionData> remove = new ArrayList<ExplosionData>();
        for (ExplosionData explosion : explosions) {
            if (event.level.m_46472_() != explosion.dimension) {
                return;
            }
            float diameter = explosion.radius * 2.0f;
            Explosion current = new Explosion(event.level, (Entity)explosion.instigator, 0.0, 0.0, 0.0, 0.0f, List.of());
            if (explosion.age == 0) {
                Object player2;
                event.level.m_6263_(null, explosion.position.f_82479_, explosion.position.f_82480_, explosion.position.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, diameter, 1.0f);
                AABB bounds = new AABB(explosion.position.f_82479_ - (double)diameter, explosion.position.f_82480_ - (double)diameter, explosion.position.f_82481_ - (double)diameter, explosion.position.f_82479_ + (double)diameter, explosion.position.f_82480_ + (double)diameter, explosion.position.f_82481_ + (double)diameter);
                for (Object player2 : event.level.m_45976_(ServerPlayer.class, bounds)) {
                    PacketHandler.sendToClient(new CameraShakeS2CPacket(1.0f, 5.0f, explosion.duration), (ServerPlayer)player2);
                }
                List entities = event.level.m_45933_(null, new AABB((double)Mth.m_14107_((double)(explosion.position.f_82479_ - (double)diameter - 1.0)), (double)Mth.m_14107_((double)(explosion.position.f_82480_ - (double)diameter - 1.0)), (double)Mth.m_14107_((double)(explosion.position.f_82481_ - (double)diameter - 1.0)), (double)Mth.m_14107_((double)(explosion.position.f_82479_ + (double)diameter + 1.0)), (double)Mth.m_14107_((double)(explosion.position.f_82480_ + (double)diameter + 1.0)), (double)Mth.m_14107_((double)(explosion.position.f_82481_ + (double)diameter + 1.0))));
                ForgeEventFactory.onExplosionDetonate((Level)event.level, (Explosion)current, (List)entities, (double)diameter);
                player2 = entities.iterator();
                while (player2.hasNext()) {
                    double d11;
                    double d9;
                    double d7;
                    double d5;
                    double d13;
                    double d12;
                    Entity entity = (Entity)player2.next();
                    if (explosion.instigator.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        ISorcererData cap = (ISorcererData)explosion.instigator.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        if (!(explosion.source instanceof JJKDamageSources.JujutsuDamageSource) && entity == explosion.instigator && (!cap.hasSelfHit() || explosion.isMelee)) continue;
                    }
                    if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20238_(explosion.position)) / (double)diameter) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - explosion.position.f_82479_) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - explosion.position.f_82480_) * d7 + (d9 = entity.m_20189_() - explosion.position.f_82481_) * d9)) == 0.0) continue;
                    d5 /= d13;
                    d7 /= d13;
                    d9 /= d13;
                    double d14 = Explosion.m_46064_((Vec3)explosion.position, (Entity)entity);
                    double d10 = (1.0 - d12) * d14;
                    entity.m_6469_(explosion.source, (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)explosion.radius + 1.0)) * explosion.damage);
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        d11 = ProtectionEnchantment.m_45135_((LivingEntity)living, (double)d10);
                    } else {
                        d11 = d10;
                    }
                    Vec3 vec31 = new Vec3(d5 *= d11, d7 *= d11, d9 *= d11);
                    entity.m_20256_(entity.m_20184_().m_82549_(vec31));
                }
            }
            if (explosion.instigator instanceof Player || event.level.m_46469_().m_46207_(GameRules.f_46132_)) {
                ObjectArrayList drops = new ObjectArrayList();
                float radius = Math.min(explosion.radius, explosion.radius * (0.5f + (float)explosion.age / (float)explosion.duration));
                int minX = Mth.m_14107_((double)(explosion.position.f_82479_ - (double)radius - 1.0));
                int maxX = Mth.m_14107_((double)(explosion.position.f_82479_ + (double)radius + 1.0));
                int minY = Mth.m_14107_((double)(explosion.position.f_82480_ - (double)radius - 1.0));
                int maxY = Mth.m_14107_((double)(explosion.position.f_82480_ + (double)radius + 1.0));
                int minZ = Mth.m_14107_((double)(explosion.position.f_82481_ - (double)radius - 1.0));
                int maxZ = Mth.m_14107_((double)(explosion.position.f_82481_ + (double)radius + 1.0));
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            double distance = ((double)x - explosion.position.f_82479_) * ((double)x - explosion.position.f_82479_) + ((double)y - explosion.position.f_82480_) * ((double)y - explosion.position.f_82480_) + ((double)z - explosion.position.f_82481_) * ((double)z - explosion.position.f_82481_);
                            if (!(distance <= (double)(radius * radius))) continue;
                            BlockPos pos = new BlockPos(x, y, z);
                            Vec3 center = pos.m_252807_();
                            if (!HelperMethods.isDestroyable((BlockGetter)event.level, explosion.instigator, pos)) continue;
                            BlockState block = event.level.m_8055_(pos);
                            FluidState fluid = event.level.m_6425_(pos);
                            float f = explosion.radius * 2.0f * (0.7f + HelperMethods.RANDOM.m_188501_() * 0.6f);
                            Optional optional = explosion.calculator.m_6617_(current, (BlockGetter)event.level, pos, block, fluid);
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (!(f > 0.0f) || !explosion.calculator.m_6714_(current, (BlockGetter)event.level, pos, block, f) || block.m_60795_()) continue;
                            BlockPos imm = pos.m_7949_();
                            if (block.canDropFromExplosion((BlockGetter)event.level, pos, current)) {
                                BlockEntity be = block.m_155947_() ? event.level.m_7702_(pos) : null;
                                LootParams.Builder params = new LootParams.Builder((ServerLevel)event.level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)be).m_287289_(LootContextParams.f_81455_, (Object)explosion.instigator).m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(explosion.radius));
                                if (!JJKAbilities.hasToggled(explosion.instigator, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get())) {
                                    block.m_222967_((ServerLevel)event.level, pos, ItemStack.f_41583_, explosion.instigator instanceof Player);
                                    for (ItemStack stack : block.m_287290_(params)) {
                                        ExplosionHandler.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, stack, imm);
                                    }
                                }
                            }
                            block.onBlockExploded(event.level, pos, current);
                            if (HelperMethods.RANDOM.m_188503_(10) == 0) {
                                ParticleUtil.sendParticles((ServerLevel)event.level, ParticleTypes.f_123813_, true, x, y, z, 0.0, 0.0, 0.0);
                            }
                            if (!explosion.fire || HelperMethods.RANDOM.m_188503_(3) != 0 || !event.level.m_8055_(pos).m_60795_() || !event.level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)event.level, pos.m_7495_())) continue;
                            event.level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)event.level, (BlockPos)pos));
                        }
                    }
                }
                for (Pair pair : drops) {
                    Block.m_49840_((Level)event.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
                }
            }
            ++explosion.age;
            if (explosion.age < explosion.duration) continue;
            remove.add(explosion);
        }
        explosions.removeAll(remove);
    }

    public static void spawn(ResourceKey<Level> dimension, Vec3 position, float radius, int duration, @Nullable LivingEntity instigator, DamageSource source, boolean causesFire) {
        explosions.add(new ExplosionData(dimension, position, radius, duration, 1.0f, instigator, source, causesFire, false));
    }

    public static void spawn(ResourceKey<Level> dimension, Vec3 position, float radius, int duration, float damage, @Nullable LivingEntity instigator, DamageSource source, boolean causesFire) {
        explosions.add(new ExplosionData(dimension, position, radius, duration, damage / 1.5f, instigator, source, causesFire, false));
    }

    public static void spawn(ResourceKey<Level> dimension, Vec3 position, float radius, int duration, float damage, @Nullable LivingEntity instigator, DamageSource source, boolean causesFire, boolean isMelee) {
        explosions.add(new ExplosionData(dimension, position, radius, duration, damage / 1.5f, instigator, source, causesFire, isMelee));
    }

    private static class ExplosionData {
        private final ExplosionDamageCalculator calculator;
        private final ResourceKey<Level> dimension;
        private final Vec3 position;
        private final float radius;
        private final int duration;
        private final float damage;
        private int age;
        @Nullable
        private final LivingEntity instigator;
        private final DamageSource source;
        private final boolean fire;
        private final boolean isMelee;

        public ExplosionData(ResourceKey<Level> dimension, Vec3 position, float radius, int duration, float damage, @Nullable LivingEntity instigator, DamageSource source, boolean fire, boolean isMelee) {
            this.calculator = instigator == null ? new ExplosionDamageCalculator() : new EntityBasedExplosionDamageCalculator((Entity)instigator);
            this.dimension = dimension;
            this.position = position;
            this.radius = radius;
            this.duration = duration;
            this.damage = damage;
            this.instigator = instigator;
            this.source = source;
            this.fire = fire;
            this.isMelee = isMelee;
        }
    }
}

