/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.angel;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.base.Transformation;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.item.JJKItems;

public class AngelWings
extends Transformation {
    private static final float SPEED = 0.006f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getTechnique() == CursedTechnique.ANGEL && super.isValid(owner);
    }

    private static double getDistanceGround(LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        Vec3 down = pos.m_82520_(0.0, -256.0, 0.0);
        BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(pos, down, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return pos.f_82480_ - result.m_82450_().f_82480_;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return AngelWings.getDistanceGround((LivingEntity)owner) > 4.0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        if (AngelWings.getDistanceGround(owner) > 4.0) {
            owner.m_183634_();
            Vec3 movement = owner.m_20184_();
            owner.m_20334_(movement.f_82479_, movement.f_82480_, movement.f_82481_);
            float f = owner.f_20900_ * 0.5f;
            float f1 = owner.f_20902_;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            owner.m_19920_(0.006f, new Vec3((double)f, 0.0, (double)f1));
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public boolean isReplacement() {
        return false;
    }

    @Override
    public Item getItem() {
        return (Item)JJKItems.WINGS.get();
    }

    @Override
    public ITransformation.Part getBodyPart() {
        return ITransformation.Part.BODY;
    }

    @Override
    public void onRightClick(LivingEntity owner) {
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }
}

