/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.angel;

import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.entity.effect.JacobsLadderEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class JacobsLadder
extends Ability {
    public static final double RANGE = 50.0;
    public LivingEntity enemy = null;
    public BlockHitResult block = null;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return true;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 50.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        Vec3 topCenter;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        LivingEntity target = this.enemy;
        Vec3 pos = target != null ? target.m_20182_() : (topCenter = Vec3.m_82512_((Vec3i)this.block.m_82425_()).m_82520_(0.0, 0.5, 0.0));
        float output = ChantHandler.getOutput(owner, this);
        JacobsLadderEntity strike = new JacobsLadderEntity(owner, this.getPower(owner), pos, output);
        owner.m_9236_().m_7967_((Entity)strike);
        this.enemy = null;
        this.block = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        BlockHitResult hit;
        if (owner.m_6144_() && (hit = this.getBlockHit(owner, 50.0)) != null) {
            this.block = hit;
            return super.isTriggerable(owner);
        }
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 50.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

