/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.base;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.AbilityDisplayInfo;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.LivingHitByDomainEvent;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public abstract class DomainExpansion
extends Ability
implements Ability.IToggled {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    protected boolean isNotDisabledFromDA() {
        return true;
    }

    @Override
    public boolean canDisable() {
        return false;
    }

    @Override
    public boolean isDomain() {
        return true;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasToggled(this)) {
            if (target != null) {
                DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
                return domain != null && domain.isInsideBarrier(target.m_20183_());
            }
        } else {
            if (target == null) {
                return false;
            }
            boolean result = cap.getType() == JujutsuType.CURSE || cap.isUnlocked((Ability)JJKAbilities.RCT1.get()) ? owner.m_21223_() / owner.m_21233_() < 0.8f : owner.m_21223_() / owner.m_21233_() < 0.3f || (double)(target.m_21223_() / target.m_21233_()) > (double)(owner.m_21223_() / owner.m_21233_()) * 1.5;
            boolean isInDomain = false;
            Iterator<DomainExpansionEntity> iterator = VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_()).iterator();
            if (iterator.hasNext()) {
                DomainExpansionEntity ignored = iterator.next();
                if ((double)owner.m_20270_((Entity)target) < 40.0) {
                    isInDomain = true;
                }
            }
            if (result && !isInDomain && (owner.m_9236_() != target.m_9236_() || (double)owner.m_20270_((Entity)target) > 30.0)) {
                return false;
            }
            Ability.Status status = this.getStatus((LivingEntity)owner);
            if (result && status == Ability.Status.SUCCESS && cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get()) && (double)cap.getExperience() < (Double)ConfigHolder.SERVER.requiredExperienceForExperienced.get()) {
                cap.toggle((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get());
            }
            return result;
        }
        return false;
    }

    public static float getStrength(LivingEntity owner, boolean instant) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        float size = cap.getDomainSize() * 0.5f - 0.15f;
        return ((Double)ConfigHolder.SERVER.maximumDomainSize.get()).floatValue() + 0.1f - size * (instant ? 0.1f : 1.0f);
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            return true;
        }
        return cap.getBrainDamage() < 10 && (technique != null && technique.getDomain() == this || cap.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT) && cap.getLastStolen() != null && cap.getLastStolen().getDomain() == this) && super.isValid(owner);
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        ISorcererData cap;
        if (!owner.m_9236_().f_46443_ && !(cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).hasSummonOfClass(DomainExpansionEntity.class)) {
            return Ability.Status.FAILURE;
        }
        return super.isStillUsable(owner);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        DomainExpansionEntity domain = this.createBarrier(owner);
        cap.addSummon(domain);
    }

    @Override
    public void onDisabled(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.unsummonByClass(DomainExpansionEntity.class);
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
        }
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 2.5f;
    }

    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingHitByDomainEvent(entity, this, owner));
    }

    public abstract void onHitBlock(DomainExpansionEntity var1, LivingEntity var2, BlockPos var3);

    protected abstract DomainExpansionEntity createBarrier(LivingEntity var1);

    @Override
    public boolean shouldLog(LivingEntity owner) {
        return false;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        CursedTechnique technique = cap.getTechnique();
        return (technique != null && technique.getDomain() == this || cap.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT) && cap.getLastStolen() != null && cap.getLastStolen().getDomain() == this) && super.isDisplayed(owner);
    }

    @Override
    public AbilityDisplayInfo getDisplay(LivingEntity owner) {
        Vec2 coordinates = this.getDisplayCoordinates();
        return new AbilityDisplayInfo("domain_expansion", coordinates.f_82470_, coordinates.f_82471_);
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(2.0f, 0.0f);
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.domainExpansionCost.get();
    }

    public static interface IOpenDomain {
        public int getWidth();

        public int getHeight();
    }

    public static interface IClosedDomain {
        default public int getSize() {
            return 20;
        }

        default public float getRadius(LivingEntity owner) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            return (float)this.getSize() * cap.getDomainSize();
        }

        public List<Block> getBlocks();

        default public List<Block> getFillBlocks() {
            return this.getBlocks();
        }

        default public List<Block> getFloorBlocks() {
            return List.of();
        }

        default public List<Block> getDecorationBlocks() {
            return List.of();
        }

        default public boolean canPlaceFloor(ClosedDomainExpansionEntity domain, BlockPos pos) {
            return true;
        }

        default public boolean canPlaceDecoration(ClosedDomainExpansionEntity domain, BlockPos pos) {
            return true;
        }

        @Nullable
        default public ParticleOptions getEnvironmentParticle() {
            return null;
        }
    }
}

