/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.boogie_woogie;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.entity.projectile.CursedEnergyImbuedItemProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class SwapSelf
extends Ability {
    public static final double RANGE = 50.0;
    public Entity enemy = null;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return this.getTarget((LivingEntity)owner) == target && HelperMethods.RANDOM.m_188503_(3) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    public static boolean canSwap(Entity target) {
        LivingEntity living;
        ItemEntity item;
        return (target.m_6087_() || target instanceof ItemEntity && (item = (ItemEntity)target).m_32055_().m_41720_() instanceof CursedToolItem || target instanceof CursedEnergyImbuedItemProjectile || target instanceof JujutsuProjectile) && (!(target instanceof LivingEntity) || !JJKAbilities.hasTrait(living = (LivingEntity)target, Trait.HEAVENLY_RESTRICTION));
    }

    @Nullable
    private Entity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 50.0);
        if (target != null) {
            return SwapSelf.canSwap((Entity)target) ? target : null;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Entity target = this.enemy;
        if (target != null) {
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.CLAP.get(), SoundSource.MASTER, 2.0f, 1.0f);
            owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.CLAP.get(), SoundSource.MASTER, 1.0f, 1.0f);
            Vec3 pos = target.m_20182_();
            Vec2 ownerRot = owner.m_20155_();
            Vec2 targetRot = target.m_20155_();
            target.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                cap.setSelfHit(15);
                cap.setExtraMeleeTaken(20);
            });
            target.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
            owner.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            target.m_146922_(ownerRot.f_82471_);
            target.m_146926_(ownerRot.f_82470_);
            owner.m_146922_(targetRot.f_82471_);
            owner.m_146926_(targetRot.f_82470_);
        }
        this.enemy = null;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 20.0f;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        Entity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public int getCooldown() {
        return 2;
    }
}

