/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.curse_manipulation;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;
import radon.jujutsu_kaisen.util.RotationUtil;

public class EnhanceCurse
extends Ability
implements Ability.IChannelened {
    private static final double RANGE = 32.0;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return this.getTarget((LivingEntity)owner) != null;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Nullable
    private CursedSpirit getTarget(LivingEntity owner) {
        EntityHitResult hit;
        HitResult hitResult = RotationUtil.getLookAtHit((Entity)owner, 32.0);
        if (hitResult instanceof EntityHitResult && (hitResult = (hit = (EntityHitResult)hitResult).m_82443_()) instanceof CursedSpirit) {
            float experience;
            CursedSpirit curse = (CursedSpirit)hitResult;
            if (curse.m_269323_() != owner) {
                return null;
            }
            if (!curse.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return null;
            }
            ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (owner.m_9236_().f_46443_) {
                ClientVisualHandler.ClientData data = ClientVisualHandler.get((Entity)curse);
                if (data == null) {
                    return null;
                }
                experience = data.experience;
            } else {
                ISorcererData curseCap = (ISorcererData)curse.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                experience = curseCap.getExperience();
            }
            if (experience >= ownerCap.getExperience() || (double)experience == (Double)ConfigHolder.SERVER.maximumExperienceAmount.get()) {
                return null;
            }
            return curse;
        }
        return null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        CursedSpirit target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        CursedSpirit target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isStillUsable(owner);
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        CursedSpirit target = this.getTarget(owner);
        if (target == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.addExperience(50.0f);
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237110_((String)String.format("chat.%s.enhance_curse", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(cap.getExperience()), ConfigHolder.SERVER.maximumExperienceAmount.get()}), false), player);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

