/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.DisasterPlantEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class DisasterPlant
extends Ability {
    public static final double RANGE = 32.0;
    public LivingEntity enemy = null;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 32.0);
        if (target != null) {
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        LivingEntity target = this.enemy;
        DisasterPlantEntity plant = new DisasterPlantEntity(owner, this.getPower(owner), target);
        owner.m_9236_().m_7967_((Entity)plant);
        this.enemy = null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target;
        this.enemy = target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 200.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PLANTS;
    }
}

