/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.ForestSpikeEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ForestSpikes
extends Ability {
    private static final double RANGE = 30.0;
    private static final float SPREAD = 25.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(3) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private BlockHitResult getBlockHit(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(30.0)));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)result;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            Vec3 offset = entity.m_20182_().m_82492_(0.0, 5.0, 0.0);
            return owner.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        }
        return null;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    private void spawnSpike(LivingEntity owner, Direction dir, BlockPos pos, double offset1, double offset2) {
        ForestSpikeEntity spike = new ForestSpikeEntity(owner, this.getPower(owner));
        Vec3 spawnPos = switch (dir.m_122434_()) {
            case Direction.Axis.Y -> pos.m_252807_().m_82520_(offset1, 0.0, offset2);
            case Direction.Axis.X -> pos.m_252807_().m_82520_(0.0, offset1, offset2);
            case Direction.Axis.Z -> pos.m_252807_().m_82520_(offset1, offset2, 0.0);
            default -> pos.m_252807_();
        };
        float yRot = dir.m_122435_() + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 60.0f;
        float xRot = (float)(Mth.m_14136_((double)dir.m_122430_(), (double)dir.m_122429_()) * 180.0 / 3.1415927410125732) + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 60.0f;
        if (dir == Direction.UP || dir == Direction.DOWN) {
            xRot = -xRot;
        }
        if (dir == Direction.WEST) {
            xRot -= 180.0f;
        }
        spike.m_146922_(yRot);
        spike.m_146926_(xRot);
        Vec3 rayDir = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()).m_82490_(-1.0);
        Vec3 rayStart = spawnPos;
        Vec3 rayEnd = spawnPos.m_82549_(rayDir.m_82490_(5.0));
        BlockHitResult hitResult = owner.m_9236_().m_45547_(new ClipContext(rayStart, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)spike));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = hitResult.m_82425_();
            BlockPos airCheck = blockPos.m_121945_(dir);
            if (!owner.m_9236_().m_8055_(airCheck).m_60795_()) {
                spike.m_146870_();
                return;
            }
            double blockCenterX = (double)blockPos.m_123341_() + 0.5;
            double blockCenterY = (double)blockPos.m_123342_() + 0.5;
            double blockCenterZ = (double)blockPos.m_123343_() + 0.5;
            double extraOffset = -0.25;
            double pushDistance = 0.5 + (double)(spike.m_20206_() / 2.0f) + extraOffset;
            double finalX = blockCenterX + (double)dir.m_122429_() * pushDistance;
            double finalY = blockCenterY + (double)dir.m_122430_() * pushDistance;
            double finalZ = blockCenterZ + (double)dir.m_122431_() * pushDistance;
            spike.m_7678_(finalX, finalY, finalZ, yRot, xRot);
            owner.m_9236_().m_7967_((Entity)spike);
        } else {
            spike.m_146870_();
        }
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        BlockHitResult hit = this.getBlockHit(owner);
        if (hit != null) {
            owner.m_9236_().m_5594_(null, hit.m_82425_(), (SoundEvent)JJKSounds.FOREST_SPIKES.get(), SoundSource.MASTER, 1.0f, 1.0f);
            Direction dir = hit.m_82434_();
            BlockPos pos = hit.m_82425_();
            double offset1 = 0.0;
            double offset2 = 0.0;
            this.spawnSpike(owner, dir, pos, offset1, offset2);
            for (int i = 0; i < 63; ++i) {
                offset1 = (HelperMethods.RANDOM.m_188500_() - 0.5) * 25.0;
                offset2 = (HelperMethods.RANDOM.m_188500_() - 0.5) * 25.0;
                this.spawnSpike(owner, dir, pos, offset1, offset2);
            }
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 150.0f;
    }

    @Override
    public int getCooldown() {
        return 300;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PLANTS;
    }
}

