/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.ForestWaveEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ForestWave
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final int DELAY = 1;
    private static final int SPEED = 5;
    private static final Map<UUID, Vec3> START_POSITIONS = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> LAST_POSITIONS = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> START_POSITIONSR = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> LAST_POSITIONSR = new HashMap<UUID, Vec3>();

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || !owner.m_142582_((Entity)target)) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(5) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(1) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void onStart(LivingEntity owner) {
        LAST_POSITIONS.remove(owner.m_20148_());
        START_POSITIONS.remove(owner.m_20148_());
        LAST_POSITIONSR.remove(owner.m_20148_());
        START_POSITIONSR.remove(owner.m_20148_());
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        int charge = this.getCharge(owner);
        double totalLength = charge;
        double segmentDistance = 0.75;
        int segmentsPerRun = 3;
        float xRot = owner.m_146909_();
        float yRot = owner.m_146908_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82541_();
        Vec3 basePos = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
        Vec3 flatLook = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
        double sideOffset = 1.0;
        Vec3 leftOffset = flatLook.m_82524_((float)Math.toRadians(90.0)).m_82490_(sideOffset);
        Vec3 rightOffset = flatLook.m_82524_((float)Math.toRadians(-90.0)).m_82490_(sideOffset);
        Vec3 startPos = basePos.m_82549_(leftOffset);
        Vec3 startPosR = basePos.m_82549_(rightOffset);
        START_POSITIONS.put(owner.m_20148_(), startPos);
        START_POSITIONSR.put(owner.m_20148_(), startPosR);
        Vec3 lastPos = LAST_POSITIONS.getOrDefault(owner.m_20148_(), startPos);
        for (int i = 0; i < segmentsPerRun; ++i) {
            Vec3 nextPos = lastPos.m_82549_(look.m_82490_(segmentDistance));
            ForestWaveEntity forest = new ForestWaveEntity(owner, this.getPower(owner));
            forest.m_7678_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, yRot, xRot);
            forest.setDamage(charge >= 1);
            owner.m_9236_().m_7967_((Entity)forest);
            lastPos = nextPos;
        }
        LAST_POSITIONS.put(owner.m_20148_(), lastPos);
        Vec3 lastPosR = LAST_POSITIONSR.getOrDefault(owner.m_20148_(), startPosR);
        for (int i = 0; i < segmentsPerRun; ++i) {
            Vec3 nextPos = lastPosR.m_82549_(look.m_82490_(segmentDistance));
            ForestWaveEntity forest = new ForestWaveEntity(owner, this.getPower(owner));
            forest.m_7678_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, yRot, xRot);
            forest.setDamage(charge >= 1);
            owner.m_9236_().m_7967_((Entity)forest);
            lastPosR = nextPos;
        }
        LAST_POSITIONSR.put(owner.m_20148_(), lastPosR);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 5.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getDuration() {
        return 4;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PLANTS;
    }
}

