/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.base.Transformation;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ArmBlade
extends Transformation {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("2b553d20-2aab-46c3-9199-4c6500948aaa");

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (JJKAbilities.hasToggled((LivingEntity)owner, this)) {
            return target != null && !target.m_21224_() && HelperMethods.RANDOM.m_188503_(20) != 0;
        }
        return target != null && !target.m_21224_() && HelperMethods.RANDOM.m_188503_(5) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.2f;
    }

    @Override
    public boolean isReplacement() {
        return false;
    }

    @Override
    public Item getItem() {
        return (Item)JJKItems.ARM_BLADE.get();
    }

    @Override
    public ITransformation.Part getBodyPart() {
        return ITransformation.Part.RIGHT_ARM;
    }

    @Override
    public void onRightClick(LivingEntity owner) {
    }

    @Override
    public void applyModifiers(LivingEntity owner) {
        EntityUtil.applyModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Attack damage", 1.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void removeModifiers(LivingEntity owner) {
        EntityUtil.removeModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID);
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return !JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.INSTANT_SPIRIT_BODY_OF_DISTORTED_KILLING.get()) && super.isValid(owner);
    }

    @Override
    public float getSlimTranslation() {
        return 0.0625f;
    }
}

