/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.base.Transformation;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Wings
extends Transformation {
    private static final float SPEED = 0.01f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    private static double getDistanceGround(LivingEntity entity) {
        Vec3 pos = entity.m_20182_();
        Vec3 down = pos.m_82520_(0.0, -256.0, 0.0);
        BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(pos, down, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return pos.f_82480_ - result.m_82450_().f_82480_;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return Wings.getDistanceGround((LivingEntity)owner) > 4.0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        if (Wings.getDistanceGround(owner) > 4.0) {
            owner.m_183634_();
            Vec3 movement = owner.m_20184_();
            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
            owner.m_20334_(movement.f_82479_, look.f_82480_, movement.f_82481_);
            float f = owner.f_20900_ * 0.5f;
            float f1 = owner.f_20902_;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            owner.m_19920_(0.01f, new Vec3((double)f, 0.0, (double)f1));
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public boolean isReplacement() {
        return false;
    }

    @Override
    public Item getItem() {
        return (Item)JJKItems.WINGS.get();
    }

    @Override
    public ITransformation.Part getBodyPart() {
        return ITransformation.Part.BODY;
    }

    @Override
    public void onRightClick(LivingEntity owner) {
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return !JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.INSTANT_SPIRIT_BODY_OF_DISTORTED_KILLING.get()) && super.isValid(owner);
    }

    @Override
    public boolean usesHands() {
        return false;
    }
}

