/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.item.cursed_tool.PolearmStaffItem;
import radon.jujutsu_kaisen.item.cursed_tool.SlaughterDemonItem;
import radon.jujutsu_kaisen.item.cursed_tool.SteelGauntletItem;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Barrage
extends Ability {
    private static final double RANGE = 9.0;
    public static int DURATION = 8;
    private static final int STAGGER = 7;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        if ((double)owner.m_20270_((Entity)target) > 9.0) {
            return false;
        }
        if (owner.m_21023_((MobEffect)JJKEffects.STAGGER.get())) {
            return false;
        }
        return HelperMethods.RANDOM.m_188503_(5) == 0;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int gap = 2;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int duration2 = DURATION;
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            duration2 = 10;
        }
        double newRange = 9.0;
        int newStagger = 7;
        Vec3 look1 = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        int dash = cap.getDash();
        if (dash > 0) {
            newRange += 1.5;
            duration2 += 2;
            Vec3 pos = owner.m_146892_().m_82549_(look1);
            owner.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12517_, SoundSource.MASTER, 1.0f, 1.5f);
        }
        if (cap.getSpeedStacks() > 0) {
            newRange = 9.0 + (double)cap.getSpeedStacks() / 3.0;
        }
        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof PolearmStaffItem) {
            newRange += 1.25;
        }
        if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SlaughterDemonItem) {
            newStagger += 4;
        }
        for (int i = 0; i < duration2; ++i) {
            double finalNewRange = newRange;
            int finalStagger = newStagger;
            cap.delayTickEvent(() -> {
                owner.m_21011_(InteractionHand.MAIN_HAND, true);
                Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                if (level2 instanceof ServerLevel) {
                    Vec3 pos;
                    int j;
                    for (j = 0; j < 4; ++j) {
                        pos = owner.m_146892_().m_82549_(look.m_82490_(2.5));
                        Item item = owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                        level2.m_8767_((ParticleOptions)(item instanceof SwordItem && !(item instanceof SteelGauntletItem) ? ParticleTypes.f_123766_ : ParticleTypes.f_123796_), pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
                    }
                    for (j = 0; j < 4; ++j) {
                        pos = owner.m_146892_().m_82549_(look.m_82490_(2.5));
                        level2.m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82480_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, pos.f_82481_ + (HelperMethods.RANDOM.m_188500_() - 0.5) * 2.5, 0, 0.0, 0.0, 0.0, 1.0);
                    }
                    Vec3 pos2 = owner.m_146892_().m_82549_(look);
                    owner.m_9236_().m_6263_(null, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_, SoundEvents.f_12317_, SoundSource.MASTER, 1.0f, 1.3f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.2f);
                    owner.m_9236_().m_6263_(null, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_, SoundEvents.f_184214_, SoundSource.MASTER, 1.0f, 1.9f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.4f);
                }
                Vec3 offset = owner.m_146892_().m_82549_(look.m_82490_(finalNewRange / 2.0 - 2.0));
                for (LivingEntity entity2 : owner.m_9236_().m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)offset, (double)finalNewRange, (double)(finalNewRange + 2.0), (double)finalNewRange), entity -> entity != owner)) {
                    Vec3 center = entity2.m_20182_().m_82520_(0.0, (double)(entity2.m_20206_() / 2.0f), 0.0);
                    if (owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SteelGauntletItem) {
                        entity2.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_12600_, SoundSource.MASTER, 1.5f, 0.8f);
                    }
                    entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), finalStagger, 0, false, false, false));
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        player.m_5706_((Entity)entity2);
                    } else {
                        owner.m_7327_((Entity)entity2);
                    }
                    entity2.f_19802_ = 0;
                }
            }, i * gap);
        }
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcerer sorcerer;
        return (!(owner instanceof ISorcerer) || (sorcerer = (ISorcerer)owner).hasMeleeAttack() && sorcerer.hasArms()) && super.isValid(owner);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return owner.m_6117_() ? Ability.Status.FAILURE : super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 0.0f : 25.0f;
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isMelee() {
        return true;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.MELEE;
    }
}

