/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.MirageParticle;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Blitz
extends Ability {
    private static final double RANGE = 40.0;
    public static int DURATION = 10;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return false;
        }
        if (!owner.m_142582_((Entity)target) || (double)owner.m_20270_((Entity)target) > 40.0) {
            return false;
        }
        return HelperMethods.RANDOM.m_188503_(6) == 0;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private Vec3 getTarget(LivingEntity owner) {
        Vec3 look;
        Vec3 end;
        Vec3 start = owner.m_146892_();
        HitResult result = RotationUtil.getHitResult((Entity)owner, start, end = start.m_82549_((look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner)).m_82490_(40.0)));
        return result.m_6662_() == HitResult.Type.MISS ? end : result.m_82450_();
    }

    @Override
    public void run(LivingEntity owner) {
        Vec3 look2 = RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(5.0);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Vec3 target = this.getTarget(owner);
        Vec3 ogPos = owner.m_20182_();
        Vec3 oldV = owner.m_20184_();
        owner.m_20219_(target);
        owner.m_20256_(oldV);
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 5, 0, false, false, false));
        level2.m_8767_((ParticleOptions)new MirageParticle.MirageParticleOptions(owner.m_19879_()), ogPos.f_82479_, ogPos.f_82480_, ogPos.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
        double dist = ogPos.m_82554_(target);
        owner.m_9236_().m_6263_(null, target.f_82479_, target.f_82480_, target.f_82481_, SoundEvents.f_215771_, SoundSource.MASTER, 0.8f, 1.0f);
        owner.m_9236_().m_6263_(null, target.f_82479_, target.f_82480_, target.f_82481_, SoundEvents.f_11928_, SoundSource.MASTER, 2.0f, 0.7f);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        level2.m_8767_((ParticleOptions)ParticleTypes.f_123747_, ogPos.f_82479_, ogPos.f_82480_ + 1.0, ogPos.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
        level2.m_8767_((ParticleOptions)ParticleTypes.f_235902_, ogPos.f_82479_, ogPos.f_82480_ + 1.0, ogPos.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
        Vec3 pos = owner.m_146892_().m_82549_(look);
        owner.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11916_, SoundSource.MASTER, 1.0f, 1.0f);
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.DASH.get(), SoundSource.MASTER, 1.0f, 2.0f);
        ArrayList<String> targets = new ArrayList<String>();
        for (double i = 0.0; i < dist; i += 0.2) {
            Vec3 cPos = ogPos.m_165921_(target, 1.0 / dist * i).m_82520_(0.0, 1.0, 0.0);
            level2.m_8767_((ParticleOptions)ParticleTypes.f_175830_, cPos.f_82479_, cPos.f_82480_, cPos.f_82481_, 0, look2.f_82479_ / 4.0, look2.f_82480_ / 4.0, look2.f_82481_ / 4.0, 0.0);
            for (LivingEntity entity2 : owner.m_9236_().m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)cPos, (double)8.0, (double)8.0, (double)8.0), entity -> entity != owner)) {
                DamageSource damageSource;
                Player player;
                boolean found = false;
                for (String enemy : targets) {
                    if (!Objects.equals(enemy, entity2.m_20149_())) continue;
                    found = true;
                }
                if (found) continue;
                targets.add(entity2.m_20149_());
                Vec3 center = entity2.m_20182_().m_82520_(0.0, (double)(entity2.m_20206_() / 2.0f), 0.0);
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123747_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                entity2.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
                if (owner instanceof Player) {
                    Player player2 = (Player)owner;
                    player2.m_5706_((Entity)entity2);
                } else {
                    owner.m_7327_((Entity)entity2);
                }
                entity2.f_19802_ = 0;
                float newDMG = 8.0f;
                if (owner instanceof Player) {
                    player = (Player)owner;
                } else {
                    newDMG /= 1.65f;
                }
                if (owner instanceof Player) {
                    player = (Player)owner;
                    damageSource = owner.m_269291_().m_269075_(player);
                } else {
                    damageSource = owner.m_269291_().m_269333_(owner);
                }
                if (!entity2.m_6469_(damageSource, newDMG * 1.45f * this.getPower(owner))) continue;
                entity2.m_20256_(look.m_82490_((double)(1.0f * (1.0f + this.getPower(owner) * 0.1f) * 2.0f)).m_82542_(1.0, 0.25, 1.0));
            }
        }
        for (int i = 0; i < 4; ++i) {
            cap.delayTickEvent(() -> {
                for (int a = 0; a < 5; ++a) {
                    double xPos = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
                    double yPos = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
                    double zPos = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_175830_, xPos, yPos, zPos, 0, look2.f_82479_ / 4.0, look2.f_82480_ / 4.0, look2.f_82481_ / 4.0, 0.0);
                }
            }, i);
        }
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcerer sorcerer;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return (!(owner instanceof ISorcerer) || (sorcerer = (ISorcerer)owner).hasMeleeAttack() && sorcerer.hasArms()) && cap.hasTrait(Trait.HEAVENLY_RESTRICTION) && super.isValid(owner);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        return owner.m_6117_() ? Ability.Status.FAILURE : super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 0.0f : 15.0f;
    }

    @Override
    public int getCooldown() {
        return 560;
    }

    @Override
    public boolean isMelee() {
        return true;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

