/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.util.HelperMethods;

public class RCT1
extends Ability
implements Ability.IChannelened {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return owner.m_21223_() / owner.m_21233_() <= 0.6f;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getEnergy() < cap.getMaxEnergy() * 0.02f) {
            return;
        }
        float heal = ((Double)ConfigHolder.SERVER.sorcererHealingAmount.get()).floatValue();
        float power = this.getPower(owner);
        if (cap.hasTrait(Trait.DEATH_PAINTING)) {
            if (owner instanceof Player) {
                player = (Player)owner;
                owner.m_5634_(heal * power * 0.2f * this.healMult() + 0.5f);
            } else {
                owner.m_5634_((float)Math.min(1.0, (double)heal * Math.pow(power * 0.175f, Math.log(power)) * (double)0.175f) + 0.075f);
            }
        } else if (owner instanceof Player) {
            player = (Player)owner;
            owner.m_5634_(heal * power * 0.225f * this.healMult() + 0.75f);
        } else {
            owner.m_5634_((float)Math.min(1.0, (double)heal * Math.pow(power * 0.175f, Math.log(power)) * (double)0.15f) + 0.1f);
        }
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (int i = 0; i < 2; ++i) {
            cap.delayTickEvent(() -> {
                for (int j = 0; j < 2; ++j) {
                    double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
                    double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
                    double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
                    double speed = (double)(owner.m_20206_() * 0.1f) * HelperMethods.RANDOM.m_188500_();
                    level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.RCT, owner.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
                }
            }, i * 2);
        }
    }

    public float healMult() {
        return 1.25f;
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getEnergy() < 100.0f) {
            return 0.0f;
        }
        if (owner.m_21223_() < owner.m_21233_()) {
            float base = ((Double)ConfigHolder.SERVER.sorcererHealingAmount.get()).floatValue() * this.getPower(owner) * this.getMultiplier();
            if (cap.hasTrait(Trait.DEATH_PAINTING)) {
                if (owner instanceof Player) {
                    return base + 6.0f;
                }
                return base + 1.75f;
            }
            if (owner instanceof Player) {
                return base + 9.0f;
            }
            return base + 3.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean isUnlockable() {
        return this == JJKAbilities.RCT1.get() || super.isUnlockable();
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        return true;
    }

    @Override
    public boolean canUnlock(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.SORCERER && super.canUnlock(owner);
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(2.0f, 2.0f);
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.NONE;
    }

    protected float getMultiplier() {
        return 2.25f;
    }
}

