/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.misc.RCT1;
import radon.jujutsu_kaisen.config.ConfigHolder;

public class RCT2
extends RCT1 {
    private static final List<MobEffect> HARMFUL = new ArrayList<MobEffect>();

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        for (MobEffect effect : owner.m_21221_().keySet()) {
            if (!HARMFUL.contains(effect)) continue;
            return true;
        }
        return super.shouldTrigger(owner, target);
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        super.run(owner);
        owner.m_21220_().removeIf(instance -> HARMFUL.contains(instance.m_19544_()));
    }

    @Override
    public float getCost(LivingEntity owner) {
        float cost = super.getCost(owner);
        for (MobEffect effect : owner.m_21221_().keySet()) {
            if (!HARMFUL.contains(effect)) continue;
            cost += 0.05f;
            break;
        }
        return cost;
    }

    @Override
    public float healMult() {
        return 1.75f;
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.RCT1.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(3.0f, 2.0f);
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.rct2Cost.get();
    }

    @Override
    protected float getMultiplier() {
        return 4.0f;
    }

    static {
        HARMFUL.add(MobEffects.f_19610_);
        HARMFUL.add(MobEffects.f_19614_);
        HARMFUL.add(MobEffects.f_19615_);
        HARMFUL.add(MobEffects.f_19604_);
    }
}

